/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml.feeds;

import java.io.InputStream;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyException;
import org.openprivacy.reptile.ContentFeed;
import org.openprivacy.reptile.ContentTransformerMap;
import org.openprivacy.reptile.om.ChannelsPeer;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import talon.util.Log;

public class OCSContentFeedsHandler
extends DefaultHandler {
    private String baseLocation = "";
    private String formatLocation = "";
    private int locationLevel = 0;
    private int level = 0;
    private String title = "";
    private String description = "";
    private String format = "";
    private String currentLocal = "";
    private String currentNS = "";
    private ContentFeed feed = null;
    private ContentTransformerMap ctm = ContentTransformerMap.getInstance();
    private int totalFound = 0;
    private String feedLocation = "urn:undefined";

    public OCSContentFeedsHandler(InputStream is) throws ReptileException {
        this.handle(new InputSource(is));
    }

    public OCSContentFeedsHandler(InputSource is) throws ReptileException {
        this.handle(is);
    }

    public OCSContentFeedsHandler(String feedLocation) throws ReptileException {
        this.feedLocation = feedLocation;
        try {
            Proxy proxy = ReptileResources.getInstance().getProxy();
            InputSource is = new InputSource(proxy.get(feedLocation).getInputStream());
            this.handle(is);
        }
        catch (ProxyException pe) {
            throw new ReptileException(pe);
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ReptileException(t);
        }
    }

    private void handle(InputSource is) throws ReptileException {
        try {
            XMLReader xmlr = ReptileParserFactory.getXMLReader();
            xmlr.setContentHandler(this);
            xmlr.parse(is);
            Log.message((Object)("Found " + this.totalFound + " channels. "));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ReptileException(t);
        }
    }

    public void startElement(String ns_uri, String local, String raw, Attributes attrs) {
        this.currentLocal = local;
        this.currentNS = ns_uri;
        if (ns_uri.equals(ReptileResources.RDF_NAMESPACE) && local.toLowerCase().equals("description")) {
            ++this.level;
            String attr_about = attrs.getValue("about");
            if (attr_about != null) {
                if (this.level == 2) {
                    this.baseLocation = attr_about;
                } else if (this.level == 3) {
                    this.formatLocation = attr_about;
                }
            }
        }
    }

    public void endElement(String ns_uri, String local, String qName) {
        this.currentLocal = "";
        this.currentNS = "";
        if (ns_uri.equals(ReptileResources.RDF_NAMESPACE) && local.toLowerCase().equals("description")) {
            if (this.level == 2) {
                if (this.feed != null) {
                    ++this.totalFound;
                    try {
                        ChannelsPeer.registerChannel(this.feed);
                    }
                    catch (Exception e) {
                        Log.error((Throwable)e);
                    }
                }
                this.reset();
            }
            if (this.level == 3) {
                if (this.feed == null && this.ctm.isSupportedContentType(this.format)) {
                    this.feed = this.getContentFeed();
                } else if (this.ctm.isPreferredContentType(this.format)) {
                    this.feed = this.getContentFeed();
                }
            }
            --this.level;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.currentLocal.equals("title")) {
            this.title = new String(ch, start, length);
        }
        if (this.currentNS.equals(ReptileResources.OCS_NAMESPACE) && this.currentLocal.equals("format")) {
            this.format = new String(ch, start, length);
        }
        if (this.currentNS.equals(ReptileResources.DC_NAMESPACE) && this.currentLocal.equals("description")) {
            this.description = new String(ch, start, length);
        }
    }

    private void reset() {
        this.title = "";
        this.description = "";
        this.baseLocation = "";
        this.formatLocation = "";
        this.format = "";
        this.feed = null;
    }

    private ContentFeed getContentFeed() {
        return new ContentFeed(this.formatLocation, this.format, this.title, this.description);
    }
}

