/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml.feeds;

import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.tasks.ContentFeedUpdateTask;
import org.openprivacy.reptile.tasks.TaskManager;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import talon.util.Log;
import talon.util.net.URI;

public class ContentFeedsHandler
extends DefaultHandler {
    public static final URI RESOURCE = new URI("resource:/xml/content/feeds/content-feeds.xml");
    private String location = "";
    private String contentType = "";
    private String updatePeriod = "";
    private String updateFrequency = "";
    private String local = "";

    public ContentFeedsHandler() throws ReptileException {
        try {
            Proxy proxy = ReptileResources.getInstance().getProxy();
            XMLReader xmlr = ReptileParserFactory.getXMLReader();
            xmlr.setContentHandler(this);
            InputSource is = new InputSource(proxy.get(RESOURCE).getInputStream());
            xmlr.parse(is);
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ReptileException(t);
        }
    }

    public void startElement(String ns_uri, String local, String raw, Attributes attrs) {
        this.local = local;
        if (ns_uri.equals("http://schemas.openprivacy.org/reptile/content-feeds") && local.equals("feed")) {
            this.location = attrs.getValue("location");
            this.contentType = attrs.getValue("contentType");
        }
    }

    public void endElement(String ns_uri, String local, String qName) {
        this.local = "";
        if (ns_uri.equals("http://schemas.openprivacy.org/reptile/content-feeds") && local.equals("feed")) {
            int frequency = Integer.parseInt(this.updateFrequency);
            long interval = 0L;
            if (this.updatePeriod.equals("daily")) {
                interval = 86400000 * frequency;
            } else if (this.updatePeriod.equals("hourly")) {
                interval = 3600000 * frequency;
            } else {
                throw new RuntimeException("Invalid updatePeriod -> " + this.updatePeriod);
            }
            Log.debug((Object)("Found content feed: " + this.location));
            ContentFeedUpdateTask task = new ContentFeedUpdateTask(this.location, this.contentType);
            task.setType("urn:task/type/ocs");
            task.setInterval(interval);
            try {
                TaskManager.getInstance().start(task);
                Proxy proxy = ReptileResources.getInstance().getProxy();
                if (proxy.contains(this.location)) {
                    ProxyEntry entry = proxy.get(this.location);
                    entry.setMinCachedInterval(interval);
                    entry.save();
                }
            }
            catch (Throwable t) {
                Log.error((Throwable)t);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.local.equals("updateFrequency")) {
            this.updateFrequency = new String(ch, start, length);
        }
        if (this.local.equals("updatePeriod")) {
            this.updatePeriod = new String(ch, start, length);
        }
    }
}

