/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.util.Hashtable;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import talon.util.Log;
import talon.util.net.URI;

public class ReptileTransformerFactory {
    private Hashtable proxyEntryCache = new Hashtable();
    private Hashtable templatesCache = new Hashtable();
    private Proxy proxy = ReptileResources.getInstance().getProxy();
    private static ReptileTransformerFactory instance = null;

    public Transformer getTransformer(URI stylesheet) throws ReptileException {
        try {
            XMLReader xmlReader = ReptileParserFactory.getXMLReader();
            Transformer t = this.getTemplates(stylesheet.toString()).newTransformer();
            t.setURIResolver(this.proxy.getURIResolver());
            return t;
        }
        catch (Exception e) {
            throw new ReptileException(e);
        }
    }

    private Templates getTemplates(String stylesheet) throws Exception {
        Log.debug((Object)("Getting template for: " + stylesheet));
        ProxyEntry pe = (ProxyEntry)this.proxyEntryCache.get(stylesheet);
        if (pe == null) {
            pe = this.proxy.get(stylesheet);
            this.proxyEntryCache.put(stylesheet, pe);
        }
        if (pe.hasChanged()) {
            Log.message((Object)("Template changed, updating cache: " + stylesheet));
            this.proxyEntryCache.put(stylesheet, this.proxy.get(stylesheet));
            return this.newTemplates(stylesheet);
        }
        Templates templates = (Templates)this.templatesCache.get(stylesheet);
        if (templates == null) {
            return this.newTemplates(stylesheet);
        }
        Log.debug((Object)("Found templates in cache: " + stylesheet));
        return templates;
    }

    private Templates newTemplates(String stylesheet) throws Exception {
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        InputSource is = new InputSource(this.proxy.get(stylesheet).getInputStream());
        SAXSource source = new SAXSource(xmlReader, is);
        Templates templates = this.newTransformerFactory().newTemplates(source);
        this.templatesCache.put(stylesheet, templates);
        return templates;
    }

    private TransformerFactory newTransformerFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setURIResolver(this.proxy.getURIResolver());
        return tf;
    }

    public void flushTemplatesCache() {
        this.templatesCache = new Hashtable();
    }

    public static ReptileTransformerFactory getInstance() {
        if (instance == null) {
            instance = new ReptileTransformerFactory();
        }
        return instance;
    }
}

