/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tasks;

import org.openprivacy.reptile.tasks.Task;
import talon.util.Log;

public class TaskThread
extends Thread {
    private Task task = null;
    private static ThreadGroup group = new ThreadGroup("urn:reptile/threadgroup/tasks");

    public TaskThread(Task task) {
        super(group, task.getIdentifier());
        Log.message((Object)("New thread created: " + task.getIdentifier()));
        this.task = task;
        this.start();
    }

    public void run() {
        while (true) {
            try {
                this.task.setState("Running");
                this.task.run();
                this.task.setState("Paused");
                this.task.setLastRan(System.currentTimeMillis());
                TaskThread taskThread = this;
                synchronized (taskThread) {
                    this.wait(this.task.getInterval());
                    continue;
                }
            }
            catch (Throwable t) {
                this.task.setLastMessage(t);
                Log.error((Throwable)t);
                continue;
            }
            break;
        }
    }
}

