/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tasks;

import java.util.Enumeration;
import java.util.Hashtable;
import org.openprivacy.reptile.tasks.Task;
import org.openprivacy.reptile.tasks.TaskThread;
import talon.util.Log;

public class TaskManager {
    private static TaskManager instance = null;
    private Hashtable tasks = new Hashtable();

    public static TaskManager getInstance() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    public boolean contains(String identifier) {
        return this.tasks.containsKey(identifier);
    }

    public Enumeration getTasks() {
        return this.tasks.elements();
    }

    public void start(Class clazz) throws Exception {
        this.start((Task)clazz.newInstance());
    }

    public void start(Task task) throws Exception {
        this.tasks.put(task.getIdentifier(), task);
        new TaskThread(task);
    }

    public void run(Task task) throws Exception {
        if (task.getState().equals("Paused")) {
            Task task2 = task;
            synchronized (task2) {
                task.notify();
            }
        } else {
            throw new Exception("Can't run task because it is not 'paused'.");
        }
    }

    public void run(String type) throws Exception {
        Enumeration tasks = this.getTasks();
        while (tasks.hasMoreElements()) {
            Task current = (Task)tasks.nextElement();
            if (current.getType() == null || !current.getType().equals(type)) continue;
            try {
                Log.message((Object)("Running task: " + current.getIdentifier()));
                this.run(current);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Task getTask(String identifier) throws Exception {
        return (Task)this.tasks.get(identifier);
    }
}

