/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.tasks;

import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.event.ProxyEvent;
import org.openprivacy.panther.event.ProxyEventListener;
import org.openprivacy.reptile.tasks.BaseTask;
import org.openprivacy.reptile.tasks.Task;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.feeds.OCSContentFeedsHandler;
import talon.util.Log;

public class ContentFeedUpdateTask
extends BaseTask
implements Task,
ProxyEventListener {
    private String location;
    private String contentType;

    public ContentFeedUpdateTask(String location, String contentType) {
        this.location = location;
        this.contentType = contentType;
        this.setIdentifier(location);
    }

    public void run() {
        try {
            Proxy proxy = ReptileResources.getInstance().getProxy();
            proxy.addProxyEventListener((ProxyEventListener)this);
            proxy.asyncUpdate(this.location);
            this.setLastMessage("Successful");
        }
        catch (Exception e) {
            this.setLastMessage(e);
            Log.error((Throwable)e);
        }
    }

    public void updated(ProxyEvent event) {
        ProxyEntry entry = event.getProxyEntry();
        String proxiedLocation = entry.getIdentifier().toString();
        if (proxiedLocation.equals(this.location) && this.contentType.equals(ReptileResources.OCS_NAMESPACE)) {
            try {
                new OCSContentFeedsHandler(this.location);
            }
            catch (Throwable t) {
                Log.error((Throwable)t);
            }
        }
    }
}

