/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.Record;
import java.util.Vector;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.openprivacy.reptile.ContentFeed;
import org.openprivacy.reptile.om.BaseChannelsPeer;
import org.openprivacy.reptile.om.Channels;
import talon.util.Log;

public class ChannelsPeer
extends BaseChannelsPeer {
    public static Channels getChannelByLocation(String location) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(BaseChannelsPeer.LOCATION, (Object)location);
        Vector v = BaseChannelsPeer.doSelect(criteria);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (Channels)((Object)v.elementAt(0));
        }
        throw new Exception("Too many channels found.  Location column needs to be unique.");
    }

    public static void registerChannel(ContentFeed feed) throws Exception {
        if (feed.getTitle() == null) {
            Log.debug((Object)("Feed had a null title: " + feed.getLocation()));
            return;
        }
        Channels c = ChannelsPeer.getChannelByLocation(feed.getLocation());
        if (c == null) {
            c = new Channels();
            c.setLocation(feed.getLocation());
        }
        if (c.getContentType() == null) {
            c.setContentType(feed.getContentType());
        }
        if (c.getTitle() == null) {
            c.setTitle(feed.getTitle());
        }
        if (c.getDescription() == null) {
            c.setDescription(feed.getDescription());
        }
        c.save();
    }

    public static int getCount() throws Exception {
        Vector v = BasePeer.executeQuery((String)"SELECT COUNT(*) FROM CHANNELS;");
        Record record = (Record)v.elementAt(0);
        return record.getValue(1).asInt();
    }

    public static Channels[] searchByTitle(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(BaseChannelsPeer.TITLE, (Object)query, " LIKE ");
        return ChannelsPeer.returnChannels(criteria);
    }

    public static Channels[] searchByDescription(String query) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(BaseChannelsPeer.DESCRIPTION, (Object)query, " LIKE ");
        return ChannelsPeer.returnChannels(criteria);
    }

    public static Channels[] searchByTitleAndDescription(String query) throws Exception {
        Criteria crit = new Criteria();
        Criteria.Criterion byTitle = crit.getNewCriterion(BaseChannelsPeer.TITLE, (Object)query, " LIKE ");
        Criteria.Criterion byDescription = crit.getNewCriterion(BaseChannelsPeer.DESCRIPTION, (Object)query, " LIKE ");
        crit.add(byTitle.or(byDescription));
        return ChannelsPeer.returnChannels(crit);
    }

    private static Channels[] returnChannels(Criteria crit) throws Exception {
        Vector v = BaseChannelsPeer.doSelect(crit);
        if (v.size() == 0) {
            throw new Exception("No channels found..");
        }
        Channels[] channels = new Channels[v.size()];
        v.copyInto((Object[])channels);
        return channels;
    }
}

