/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.om;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.turbine.om.NumberKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.SimpleKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.MapBuilder;
import org.apache.turbine.util.db.map.TableMap;
import org.apache.turbine.util.db.pool.DBConnection;
import org.openprivacy.reptile.om.BaseChannelsPeer;
import org.openprivacy.reptile.om.Channels;
import org.openprivacy.reptile.om.Content;
import org.openprivacy.reptile.om.map.ContentMapBuilder;

public abstract class BaseContentPeer
extends BasePeer {
    private static final ContentMapBuilder mapBuilder = (ContentMapBuilder)BasePeer.getMapBuilder((String)"org.openprivacy.reptile.om.map.ContentMapBuilder");
    public static final String TABLE_NAME = ContentMapBuilder.getTable();
    public static final String ID = ContentMapBuilder.getContent_Id();
    public static final String LOCATION = ContentMapBuilder.getContent_Location();
    public static final String TITLE = ContentMapBuilder.getContent_Title();
    public static final String DESCRIPTION = ContentMapBuilder.getContent_Description();
    public static final String CHANNEL = ContentMapBuilder.getContent_Channel();
    public static final int numColumns = 5;
    protected static final String CLASSNAME_DEFAULT = "org.openprivacy.reptile.om.Content";
    protected static final Class CLASS_DEFAULT = BaseContentPeer.initClass();

    public static MapBuilder getMapBuilder() {
        return mapBuilder;
    }

    private static Class initClass() {
        Class<?> c = null;
        try {
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e) {
            Log.error((String)"A FATAL ERROR has occurred which should nothave happened under any circumstance.  Please notifyTurbine and give as many details as possible including the error stacktrace.", (Throwable)e);
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet results) throws Exception {
        QueryDataSet qds = null;
        Vector rows = null;
        try {
            qds = new QueryDataSet(results);
            rows = BasePeer.getSelectResults((QueryDataSet)qds);
            Object var4_3 = null;
            if (qds == null) return BaseContentPeer.populateObjects(rows);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (qds == null) throw throwable;
            qds.close();
            throw throwable;
        }
        qds.close();
        return BaseContentPeer.populateObjects(rows);
    }

    public static ObjectKey doInsert(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void addSelectColumns(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ID);
        criteria.addSelectColumn(LOCATION);
        criteria.addSelectColumn(TITLE);
        criteria.addSelectColumn(DESCRIPTION);
        criteria.addSelectColumn(CHANNEL);
    }

    public static Content row2Object(Record row, int offset, Class cls) throws Exception {
        Content obj = (Content)((Object)cls.newInstance());
        BaseContentPeer.populateObject(row, offset, obj);
        obj.setModified(false);
        obj.setNew(false);
        return obj;
    }

    public static void populateObject(Record row, int offset, Content obj) throws Exception {
        obj.setId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
        obj.setLocation(row.getValue(offset + 1).asString());
        obj.setTitle(row.getValue(offset + 2).asString());
        obj.setDescription(row.getValue(offset + 3).asString());
        obj.setChannel(new NumberKey(row.getValue(offset + 4).asBigDecimal()));
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        return BaseContentPeer.populateObjects(BaseContentPeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dbCon) throws Exception {
        return BaseContentPeer.populateObjects(BaseContentPeer.doSelectVillageRecords(criteria, dbCon));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        if (criteria.getSelectColumns().size() == 0) {
            BaseContentPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dbCon) throws Exception {
        if (criteria.getSelectColumns().size() == 0) {
            BaseContentPeer.addSelectColumns(criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dbCon);
    }

    public static Vector populateObjects(Vector records) throws Exception {
        Vector<Content> results = new Vector<Content>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.elementAt(i);
            results.add(BaseContentPeer.row2Object(row, 1, BaseContentPeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws Exception {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        selectCriteria.put((Object)CHANNEL, criteria.remove(CHANNEL));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        Criteria selectCriteria = new Criteria(mapBuilder.getDatabaseMap().getName(), 2);
        selectCriteria.put((Object)ID, criteria.remove(ID));
        selectCriteria.put((Object)CHANNEL, criteria.remove(CHANNEL));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doDelete(Criteria criteria) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria);
    }

    public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception {
        criteria.setDbName(mapBuilder.getDatabaseMap().getName());
        BasePeer.doDelete((Criteria)criteria, (DBConnection)dbCon);
    }

    public static void doInsert(Content obj) throws Exception {
        BaseContentPeer.doInsert(BaseContentPeer.buildCriteria(obj));
        obj.setNew(false);
    }

    public static void doUpdate(Content obj) throws Exception {
        BaseContentPeer.doUpdate(BaseContentPeer.buildCriteria(obj));
    }

    public static void doDelete(Content obj) throws Exception {
        BaseContentPeer.doDelete(BaseContentPeer.buildCriteria(obj));
    }

    public static void doInsert(Content obj, DBConnection dbCon) throws Exception {
        BaseContentPeer.doInsert(BaseContentPeer.buildCriteria(obj), dbCon);
        obj.setNew(false);
    }

    public static void doUpdate(Content obj, DBConnection dbCon) throws Exception {
        BaseContentPeer.doUpdate(BaseContentPeer.buildCriteria(obj), dbCon);
    }

    public static void doDelete(Content obj, DBConnection dbCon) throws Exception {
        BaseContentPeer.doDelete(BaseContentPeer.buildCriteria(obj), dbCon);
    }

    public static Criteria buildCriteria(Content obj) {
        Criteria criteria = new Criteria();
        criteria.add(ID, (Object)obj.getId());
        criteria.add(LOCATION, (Object)obj.getLocation());
        criteria.add(TITLE, (Object)obj.getTitle());
        criteria.add(DESCRIPTION, (Object)obj.getDescription());
        criteria.add(CHANNEL, (Object)obj.getChannel());
        return criteria;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Content retrieveByPK(ObjectKey pk) throws Exception {
        DBConnection db = null;
        Content retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseContentPeer.retrieveByPK(pk, db);
            Object var4_3 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Content retrieveByPK(ObjectKey pk, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria();
        SimpleKey[] keys = (SimpleKey[])pk.getValue();
        criteria.add(ID, (Object)keys[0]);
        criteria.add(CHANNEL, (Object)keys[1]);
        Vector v = BaseContentPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Content)((Object)v.firstElement());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Content retrieveByPK(NumberKey id, NumberKey channel) throws Exception {
        DBConnection db = null;
        Content retVal = null;
        try {
            db = TurbineDB.getConnection((String)mapBuilder.getDatabaseMap().getName());
            retVal = BaseContentPeer.retrieveByPK(id, channel, db);
            Object var5_4 = null;
            if (db == null) return retVal;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (db == null) throw throwable;
            TurbineDB.releaseConnection((DBConnection)db);
            throw throwable;
        }
        TurbineDB.releaseConnection((DBConnection)db);
        return retVal;
    }

    public static Content retrieveByPK(NumberKey id, NumberKey channel, DBConnection dbcon) throws Exception {
        Criteria criteria = new Criteria(5);
        criteria.add(ID, (Object)id);
        criteria.add(CHANNEL, (Object)channel);
        Vector v = BaseContentPeer.doSelect(criteria, dbcon);
        if (v.size() != 1) {
            throw new Exception("Failed to select one and only one row.");
        }
        return (Content)((Object)v.firstElement());
    }

    protected static Vector doSelectJoinChannels(Criteria c) throws Exception {
        c.setDbName(mapBuilder.getDatabaseMap().getName());
        BaseContentPeer.addSelectColumns(c);
        int offset = 6;
        BaseChannelsPeer.addSelectColumns(c);
        c.addJoin(CHANNEL, BaseChannelsPeer.ID);
        Vector rows = BasePeer.doSelect((Criteria)c);
        Vector<Content> results = new Vector<Content>();
        int i = 0;
        while (i < rows.size()) {
            Record row = (Record)rows.elementAt(i);
            Class omClass = BaseContentPeer.getOMClass();
            Content obj1 = BaseContentPeer.row2Object(row, 1, omClass);
            omClass = BaseChannelsPeer.getOMClass();
            Channels obj2 = BaseChannelsPeer.row2Object(row, offset, omClass);
            boolean newObject = true;
            int j = 0;
            while (j < results.size()) {
                Content temp_obj1 = (Content)((Object)results.elementAt(j));
                Channels temp_obj2 = temp_obj1.getChannels();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey())) {
                    newObject = false;
                    temp_obj2.addContent(obj1);
                    break;
                }
                ++j;
            }
            if (newObject) {
                obj2.initContents();
                obj2.addContent(obj1);
            }
            results.add(obj1);
            ++i;
        }
        return results;
    }

    protected static TableMap getTableMap() {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }
}

