/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions.feeds;

import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.openprivacy.reptile.om.Channels;
import org.openprivacy.reptile.om.ChannelsPeer;
import org.w3c.dom.Node;
import talon.util.Log;

public class Search {
    public static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";

    public Node byTitleAndDescription(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String query = this.getQuery(context, elem);
            return this.getContent(ChannelsPeer.searchByTitleAndDescription(query));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return null;
        }
    }

    public Node byTitle(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String query = this.getQuery(context, elem);
            return this.getContent(ChannelsPeer.searchByTitle(query));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return null;
        }
    }

    public Node byDescription(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String query = this.getQuery(context, elem);
            return this.getContent(ChannelsPeer.searchByDescription(query));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return null;
        }
    }

    private String getQuery(XSLProcessorContext context, ElemExtensionCall elem) throws Exception {
        return elem.getAttribute("query", context.getContextNode(), context.getTransformer());
    }

    private Node getContent(Channels[] channels) throws Exception {
        Namespace resultsNamespace = Namespace.getNamespace((String)"results", (String)"http://schemas.openprivacy.org/reptile/search-results");
        Namespace dcNamespace = Namespace.getNamespace((String)"dc", (String)DC_NAMESPACE);
        Element results = new Element("results", resultsNamespace);
        results.setAttribute("total", Integer.toString(ChannelsPeer.getCount()));
        results.setAttribute("found", Integer.toString(channels.length));
        int i = 0;
        while (i < channels.length) {
            Channels current = channels[i];
            Element entry = new Element("entry", resultsNamespace);
            entry.addContent(new Element("title", dcNamespace).setText(current.getTitle()));
            entry.addContent(new Element("description", dcNamespace).setText(current.getDescription()));
            Element link = new Element("link", resultsNamespace);
            link.setAttribute("location", current.getLocation());
            link.setAttribute("contentType", current.getContentType());
            entry.addContent(link);
            results.addContent(entry);
            ++i;
        }
        return new DOMOutputter().output(results);
    }
}

