/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.io.IOException;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ReptileResources;
import talon.util.Log;

public class ProxyFunctions {
    private Proxy proxy = ReptileResources.getInstance().getProxy();

    public boolean contains(String location) {
        return this.proxy.contains(location);
    }

    public boolean supports(String location) {
        return this.proxy.supports(location);
    }

    public void update(String location) {
        try {
            this.proxy.update(location);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public String getFileLocation(String location) {
        if (this.proxy.contains(location)) {
            try {
                return this.proxy.get(location).getFileLocation();
            }
            catch (IOException e) {
                Log.error((Throwable)e);
                return "";
            }
        }
        return "";
    }

    public String getResourceLocation(String resource) {
        try {
            return this.proxy.getResource(resource).getURL().toString();
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return "";
        }
    }

    public String file(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String location = elem.getAttribute("location", context.getContextNode(), context.getTransformer());
            return this.getFileLocation(location);
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            return "";
        }
    }

    public String lastModified(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String location = elem.getAttribute("location", context.getContextNode(), context.getTransformer());
            if (this.proxy.contains(location)) {
                ProxyEntry entry = this.proxy.get(location);
                long lastmodified = System.currentTimeMillis() - entry.getLastModified();
                return ProxyFunctions.getDateFormated(lastmodified) + " ago";
            }
            return "Not currently available";
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return "unknown: " + e.getMessage();
        }
    }

    public String nextUpdate(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String location = elem.getAttribute("location", context.getContextNode(), context.getTransformer());
            if (this.proxy.contains(location)) {
                ProxyEntry entry = this.proxy.get(location);
                long interval = entry.getMinCachedInterval();
                long offset = System.currentTimeMillis() - entry.getLastModified();
                long difference = interval - offset;
                return ProxyFunctions.getDateFormated(difference) + " from now";
            }
            return "Not currently available";
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return "unknown: " + e.getMessage();
        }
    }

    public String updateInterval(XSLProcessorContext context, ElemExtensionCall elem) {
        try {
            String location = elem.getAttribute("location", context.getContextNode(), context.getTransformer());
            if (this.proxy.contains(location)) {
                ProxyEntry entry = this.proxy.get(location);
                long interval = entry.getMinCachedInterval();
                return ProxyFunctions.getDateFormated(interval);
            }
            return "Not currently available";
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return "unknown: " + e.getMessage();
        }
    }

    public static String getDateFormated(long difference) {
        int hours = (int)Math.floor((difference /= 1000L) / 3600L);
        int minutes = (int)Math.floor((difference - (long)(hours * 3600)) / 60L);
        int seconds = (int)difference - hours * 3600 - minutes * 60;
        StringBuffer result = new StringBuffer("");
        if (hours > 0) {
            result.append(hours + " hour(s), ");
        }
        if (minutes > 0) {
            result.append(minutes + " minute(s), ");
        }
        if ((hours > 0 || minutes > 0) && seconds > 0) {
            result.append(" and ");
        }
        result.append(seconds + " second(s) ");
        return result.toString();
    }
}

