/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import javax.xml.transform.Transformer;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.openprivacy.reptile.SequenceDispatchEngine;
import org.openprivacy.reptile.SequenceDispatchEntry;
import org.openprivacy.reptile.StylesheetEngine;
import org.openprivacy.reptile.StylesheetStack;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ContentTransformerHandler;
import org.openprivacy.reptile.xml.serializers.ErrorXMLSerializer;
import talon.Assert;
import talon.util.Log;

public class ContentTransformer {
    public static final String REPTILE_CONTENT_LOCATION_KEY = "reptile.content.location";
    private ParameterPasser params = null;

    public ContentTransformer(ParameterPasser params) {
        this.params = params;
    }

    public ContentTransformer() {
    }

    public void init(XSLProcessorContext context, ElemExtensionCall elem) {
        Log.debug((Object)"INIT ContentTransformer");
        this.params = new ParameterPasser((Transformer)context.getTransformer());
    }

    public String transform(String location, String inputFormat, String outputFormat) {
        Assert.assert((Object)location, (String)"Location must be specified.");
        Assert.assert((Object)inputFormat, (String)"inputFormat must be specified.");
        Assert.assert((Object)outputFormat, (String)"outputFormat must be specified.");
        Log.debug((Object)("Transforming location: " + location + " with inputFormat: " + inputFormat));
        this.params.put(REPTILE_CONTENT_LOCATION_KEY, location);
        System.out.println(" FIXME: (debug): setting reptile.content.location to " + location);
        if (inputFormat.equals(ReptileResources.STYLESHEET_SEQUENCE_NAMESPACE)) {
            try {
                return SequenceDispatchEngine.dispatch(location, this.params);
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                return new ErrorXMLSerializer(e).serialize();
            }
        }
        try {
            ContentTransformerHandler handler = new ContentTransformerHandler(inputFormat, outputFormat);
            StylesheetStack ss = handler.getStylesheetStack();
            SequenceDispatchEntry sde = new SequenceDispatchEntry("urn:content-transformer");
            sde.setSkeleton(location);
            sde.setStylesheetStack(ss);
            sde.setCacheable(true);
            String result = StylesheetEngine.getInstance().transform(sde, this.params);
            return result;
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            Log.debug((Object)"Dumping serialized version of exception ");
            return new ErrorXMLSerializer(t).serialize();
        }
    }
}

