/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.cache.sequence;

import java.util.Enumeration;
import java.util.Hashtable;
import org.openprivacy.reptile.SequenceDispatchEntry;
import org.openprivacy.reptile.cache.sequence.SequenceCacheEntry;
import org.openprivacy.reptile.cache.sequence.SequenceCacheHandle;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileException;
import talon.util.Log;

public class SequenceCache {
    private int cacheMisses = 0;
    private int cacheHits = 0;
    private static SequenceCache instance = null;
    private Hashtable cache = new Hashtable();

    public SequenceCacheEntry fetch(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        return this.fetch(new SequenceCacheHandle(sde, params));
    }

    public SequenceCacheEntry fetch(SequenceCacheHandle handle) throws Exception {
        String sequenceName = handle.getSequenceDispatchEntry().getName();
        if (this.contains(handle)) {
            SequenceCacheEntry entry = (SequenceCacheEntry)this.cache.get(handle);
            if (entry.stale()) {
                this.flush(handle);
                throw new ReptileException("Cache entry is stale.");
            }
            return entry;
        }
        throw new ReptileException("Sequence is not cacheable: " + sequenceName);
    }

    public boolean contains(SequenceCacheHandle handle) {
        return this.cache.containsKey(handle);
    }

    private void store(SequenceCacheHandle handle, SequenceCacheEntry entry) {
        this.cache.put(handle, entry);
    }

    public void store(SequenceCacheHandle handle, String content) throws Exception {
        this.store(handle, new SequenceCacheEntry(handle, content));
    }

    public void flush() {
        SequenceCache sequenceCache = this;
        synchronized (sequenceCache) {
            this.cache = null;
            this.cache = new Hashtable();
            this.setCacheHits(0);
            this.setCacheMisses(0);
        }
    }

    public void flush(SequenceCacheHandle handle) {
        this.cache.remove(handle);
    }

    public void flush(String location) {
        SequenceCache sequenceCache = this;
        synchronized (sequenceCache) {
            Enumeration enumeration = this.cache.keys();
            while (enumeration.hasMoreElements()) {
                SequenceCacheHandle handle = (SequenceCacheHandle)enumeration.nextElement();
                SequenceDispatchEntry sde = handle.getSequenceDispatchEntry();
                if (!sde.getSkeleton().equals(location)) continue;
                Log.message((Object)("Removing content from the cache: " + handle.toString()));
                this.flush(handle);
            }
        }
    }

    public Enumeration getEntries() {
        return this.cache.elements();
    }

    public static SequenceCache getInstance() {
        if (instance == null) {
            instance = new SequenceCache();
        }
        return instance;
    }

    public void setCacheHits(int cacheHits) {
        this.cacheHits = cacheHits;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    public void setCacheMisses(int cacheMisses) {
        this.cacheMisses = cacheMisses;
    }

    public void incrementCacheHits() {
        this.setCacheHits(this.getCacheHits() + 1);
    }

    public void incrementCacheMisses() {
        this.setCacheMisses(this.getCacheMisses() + 1);
    }
}

