/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import java.io.ByteArrayInputStream;
import org.openprivacy.reptile.om.MarksPeer;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import talon.util.Log;

class UpdateReadMarksHandler
extends DefaultHandler {
    private String operation = "";

    public UpdateReadMarksHandler(String content, String operation) throws Exception {
        Log.debug((Object)"Finding locations on which to set marks ");
        this.operation = operation;
        XMLReader xmlr = ReptileParserFactory.getXMLReader();
        xmlr.setContentHandler(this);
        xmlr.parse(new InputSource(new ByteArrayInputStream(content.getBytes())));
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (uri.equals("http://schemas.openprivacy.org/reptile/content-list") && local.equals("entry")) {
            String location = attrs.getValue("location");
            Log.debug((Object)("Setting  marks for location: " + location + " as operation: " + this.operation));
            try {
                if (this.operation.equals("read")) {
                    MarksPeer.markRead(location);
                } else {
                    MarksPeer.markUnread(location);
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                throw new SAXException(e.getMessage());
            }
        }
    }
}

