/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.xml.SequenceDispatchHandler;
import talon.Assert;
import talon.util.Log;

public class SequenceDispatchEngine {
    public static void dispatch(HttpServletRequest request, HttpServletResponse response, ParameterPasser params) throws ServletException {
        try {
            PrintWriter out = response.getWriter();
            out.println(SequenceDispatchEngine.dispatch(params));
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
            throw new ServletException(t.getMessage());
        }
    }

    public static String dispatch(ParameterPasser params) throws Exception {
        String sequenceName = (String)params.get("reptile.sequence.name");
        Assert.assert((Object)sequenceName, (String)"Sequence name may not be null.");
        SequenceDispatchHandler sdh = new SequenceDispatchHandler(sequenceName, params);
        return sdh.dispatch();
    }

    public static String dispatch(String sequenceName, ParameterPasser params) throws Exception {
        Assert.assert((Object)sequenceName, (String)"Sequence name may not be null.");
        Assert.assert((Object)params, (String)"Can not use null parameters");
        params.put("reptile.sequence.name", sequenceName);
        return SequenceDispatchEngine.dispatch(params);
    }

    public static void dispatch(HttpServletRequest request, HttpServletResponse response, String sequenceName) throws ServletException {
        Assert.assert((Object)sequenceName, (String)"Sequence name may not be null.");
        ParameterPasser params = new ParameterPasser(request, response, sequenceName);
        SequenceDispatchEngine.dispatch(request, response, params);
    }
}

