/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openprivacy.reptile.SequenceDispatchEngine;
import org.openprivacy.reptile.actions.ActionManager;
import org.openprivacy.reptile.extensions.LinkProducer;
import org.openprivacy.reptile.init.ServletInitializer;
import org.openprivacy.reptile.util.ParameterPasser;
import talon.util.Log;
import talon.util.RuntimeUtil;

public class ReptileServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            new ServletInitializer(config).init();
        }
        catch (Throwable t) {
            Log.error((Throwable)t);
        }
        Log.message((Object)"Reptile initialized...", (Object)((Object)this));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        RuntimeUtil ru = new RuntimeUtil();
        HttpSession session = request.getSession();
        if (session.isNew()) {
            String session_location = response.encodeURL("/reptile/servlet/reptile");
            Log.message((Object)("NEW SESSION " + session_location));
            session.setAttribute("reptile.home.location", (Object)session_location);
            ParameterPasser params = new ParameterPasser(request, response);
            String redirect = new LinkProducer(params, session, "urn:login").getLink();
            response.sendRedirect(redirect);
            return;
        }
        if (ActionManager.exec(request, response)) {
            return;
        }
        if (session.getAttribute("username") == null) {
            SequenceDispatchEngine.dispatch(request, response, "urn:login");
            ru.output();
            return;
        }
        String sequence = request.getParameter("reptile.sequence.name");
        if (sequence != null) {
            SequenceDispatchEngine.dispatch(request, response, sequence);
            ru.output();
            return;
        }
        PrintWriter out = response.getWriter();
        SequenceDispatchEngine.dispatch(request, response, "urn:subscriptions");
        ru.output();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

