/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.test.BaseTestCase;
import org.apache.velocity.test.TemplateTestBase;

public class EncodingTestCase
extends BaseTestCase
implements TemplateTestBase {
    public static Test suite() {
        return new EncodingTestCase();
    }

    public void runTest() {
        VelocityContext context = new VelocityContext();
        try {
            BaseTestCase.assureResultsDirectoryExists("../test/templates/results");
            Template template = Runtime.getTemplate(BaseTestCase.getFileName(null, "encodingtest", "vm"));
            FileOutputStream fos = new FileOutputStream(BaseTestCase.getFileName("../test/templates/results", "encodingtest", "res"));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            template.merge(context, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "encodingtest", "res", "cmp")) {
                Assert.fail((String)"Output incorrect.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public EncodingTestCase() {
        super("ContextSafetyTestCase");
        try {
            Velocity.setProperty("file.resource.loader.path", "../test/templates");
            Velocity.setProperty("input.encoding", "UTF-8");
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup EncodingTestCase!");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

