/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;

public class JarHolder {
    private String urlpath = null;
    private JarFile theJar = null;
    private JarURLConnection conn = null;

    public void init() {
        try {
            Runtime.info("  JarHolder : attempting to connect to " + this.urlpath);
            URL url = new URL(this.urlpath);
            this.conn = (JarURLConnection)url.openConnection();
            this.conn.setAllowUserInteraction(false);
            this.conn.setDoInput(true);
            this.conn.setDoOutput(false);
            this.conn.connect();
            this.theJar = this.conn.getJarFile();
        }
        catch (Exception e) {
            Runtime.error("  JarHolder : error establishing connection to JAR " + e);
        }
    }

    public void close() {
        try {
            this.theJar.close();
        }
        catch (Exception e) {
            Runtime.error("  JarHolder : error Closing JAR the file " + e);
        }
        this.theJar = null;
        this.conn = null;
        Runtime.info("  JarHolder : JAR file closed");
    }

    public InputStream getResource(String theentry) throws ResourceNotFoundException {
        InputStream data = null;
        try {
            JarEntry entry = this.theJar.getJarEntry(theentry);
            if (entry != null) {
                data = this.theJar.getInputStream(entry);
            }
        }
        catch (Exception fnfe) {
            Runtime.error("  JarHolder : getResource() error : exception : " + fnfe);
            throw new ResourceNotFoundException(fnfe.getMessage());
        }
        return data;
    }

    public Hashtable getEntries() {
        Hashtable<String, String> allEntries = new Hashtable<String, String>(559);
        Enumeration<JarEntry> all = this.theJar.entries();
        while (all.hasMoreElements()) {
            JarEntry je = all.nextElement();
            if (je.isDirectory()) continue;
            allEntries.put(je.getName(), this.urlpath);
        }
        return allEntries;
    }

    public String getUrlPath() {
        return this.urlpath;
    }

    public JarHolder(String urlpath) {
        this.urlpath = urlpath;
        this.init();
        Runtime.info("  JarHolder : initialized JAR: " + urlpath);
    }
}

