/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;

public class FileResourceLoader
extends ResourceLoader {
    private Vector paths = null;
    private Hashtable templatePaths = new Hashtable();

    public void init(ExtendedProperties configuration) {
        Runtime.info("FileResourceLoader : initialization starting.");
        this.paths = configuration.getVector("path");
        int sz = this.paths.size();
        int i = 0;
        while (i < sz) {
            Runtime.info("FileResourceLoader : adding path '" + (String)this.paths.get(i) + "'");
            ++i;
        }
        Runtime.info("FileResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        String template = null;
        int size = this.paths.size();
        int i = 0;
        while (i < size) {
            InputStream inputStream;
            String path = (String)this.paths.get(i);
            if (templateName == null || templateName.length() == 0) {
                throw new ResourceNotFoundException("Need to specify a file name or file path!");
            }
            template = StringUtils.normalizePath(templateName);
            if (template == null || template.length() == 0) {
                String msg = "File resource error : argument " + template + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
                Runtime.error("FileResourceLoader : " + msg);
                throw new ResourceNotFoundException(msg);
            }
            if (template.startsWith("/")) {
                template = template.substring(1);
            }
            if ((inputStream = this.findTemplate(path, template)) != null) {
                this.templatePaths.put(templateName, path);
                return inputStream;
            }
            ++i;
        }
        String msg = "FileResourceLoader Error: cannot find resource " + template;
        throw new ResourceNotFoundException(msg);
    }

    private InputStream findTemplate(String path, String template) {
        try {
            File file = new File(path, template);
            if (file.canRead()) {
                return new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public boolean isSourceModified(Resource resource) {
        String path = (String)this.templatePaths.get(resource.getName());
        File file = new File(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified() != resource.getLastModified();
        }
        return true;
    }

    public long getLastModified(Resource resource) {
        String path = (String)this.templatePaths.get(resource.getName());
        File file = new File(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }
}

