/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;

public class ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    private static final String RESOURCE_LOADER_IDENTIFIER = "_RESOURCE_LOADER_IDENTIFIER_";
    private static Hashtable globalCache = new Hashtable();
    private static ArrayList resourceLoaders = new ArrayList();
    private static ArrayList sourceInitializerList = new ArrayList();
    private static Hashtable sourceInitializerMap = new Hashtable();
    private static boolean resourceLoaderInitializersActive = false;
    private static boolean logWhenFound = true;

    public static void initialize() throws Exception {
        ResourceManager.assembleResourceLoaderInitializers();
        int i = 0;
        while (i < sourceInitializerList.size()) {
            ExtendedProperties configuration = (ExtendedProperties)sourceInitializerList.get(i);
            String loaderClass = configuration.getString("class");
            if (loaderClass == null) {
                Runtime.error("Unable to find '" + configuration.getString(RESOURCE_LOADER_IDENTIFIER) + ".resource.loader.class' specification in configuation." + " This is a critical value.  Please adjust configuration.");
            } else {
                ResourceLoader resourceLoader = ResourceLoaderFactory.getLoader(loaderClass);
                resourceLoader.commonInit(configuration);
                resourceLoader.init(configuration);
                resourceLoaders.add(resourceLoader);
            }
            ++i;
        }
        logWhenFound = Runtime.getBoolean("resource.manager.logwhenfound", true);
    }

    private static void assembleResourceLoaderInitializers() {
        if (resourceLoaderInitializersActive) {
            return;
        }
        Vector resourceLoaderNames = Runtime.getConfiguration().getVector("resource.loader");
        int i = 0;
        while (i < resourceLoaderNames.size()) {
            String loaderID = resourceLoaderNames.get(i) + "." + "resource.loader";
            ExtendedProperties loaderConfiguration = Runtime.getConfiguration().subset(loaderID);
            loaderConfiguration.setProperty(RESOURCE_LOADER_IDENTIFIER, resourceLoaderNames.get(i));
            sourceInitializerList.add(loaderConfiguration);
            ++i;
        }
        resourceLoaderInitializersActive = true;
    }

    public static Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = (Resource)globalCache.get(resourceName);
        if (resource != null) {
            if (resource.requiresChecking()) {
                resource.touch();
                if (resource.isSourceModified()) {
                    if (!resource.getEncoding().equals(encoding)) {
                        Runtime.error("Declared encoding for template '" + resourceName + "' is different on reload.  Old = '" + resource.getEncoding() + "'  New = '" + encoding);
                        resource.setEncoding(encoding);
                    }
                    try {
                        long howOldItWas = resource.getResourceLoader().getLastModified(resource);
                        resource.process();
                        resource.setLastModified(howOldItWas);
                    }
                    catch (ResourceNotFoundException rnfe) {
                        Runtime.error("ResourceManager.getResource() exception: " + rnfe);
                        throw rnfe;
                    }
                    catch (ParseErrorException pee) {
                        Runtime.error("ResourceManager.getResource() exception: " + pee);
                        throw pee;
                    }
                    catch (Exception eee) {
                        Runtime.error("ResourceManager.getResource() exception: " + eee);
                        throw eee;
                    }
                }
            }
            return resource;
        }
        try {
            resource = ResourceFactory.getResource(resourceName, resourceType);
            resource.setName(resourceName);
            resource.setEncoding(encoding);
            long howOldItWas = 0L;
            ResourceLoader resourceLoader = null;
            int i = 0;
            while (i < resourceLoaders.size()) {
                resourceLoader = (ResourceLoader)resourceLoaders.get(i);
                resource.setResourceLoader(resourceLoader);
                try {
                    if (resource.process()) {
                        if (logWhenFound) {
                            Runtime.info("ResourceManager : found " + resourceName + " with loader " + resourceLoader.getClassName());
                        }
                        howOldItWas = resourceLoader.getLastModified(resource);
                        break;
                    }
                }
                catch (ResourceNotFoundException rnfe) {
                    // empty catch block
                }
                ++i;
            }
            if (resource.getData() == null) {
                throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'");
            }
            resource.setLastModified(howOldItWas);
            resource.setModificationCheckInterval(resourceLoader.getModificationCheckInterval());
            resource.touch();
            if (resourceLoader.isCachingOn()) {
                globalCache.put(resourceName, resource);
            }
        }
        catch (ResourceNotFoundException rnfe2) {
            Runtime.error("ResourceManager : unable to find resource '" + resourceName + "' in any resource loader.");
            throw rnfe2;
        }
        catch (ParseErrorException pee) {
            Runtime.error("ResourceManager.getResource() parse exception: " + pee);
            throw pee;
        }
        catch (Exception ee) {
            Runtime.error("ResourceManager.getResource() exception: " + ee);
            throw ee;
        }
        return resource;
    }

    public static Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        return ResourceManager.getResource(resourceName, resourceType, "ISO-8859-1");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLoaderNameForResource(String resourceName) {
        resourceLoader = null;
        i = 0;
        while (true) {
            block15: {
                block13: {
                    if (i >= ResourceManager.resourceLoaders.size()) {
                        return null;
                    }
                    resourceLoader = (ResourceLoader)ResourceManager.resourceLoaders.get(i);
                    is = null;
                    try {
                        try {
                            is = resourceLoader.getResourceStream(resourceName);
                            if (is == null) break block13;
                            var6_7 = resourceLoader.getClass().toString();
                            var5_4 = null;
                            if (is == null) return var6_7;
                        }
                        catch (ResourceNotFoundException e) {
                            var5_4 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ioe) {}
                            }
                            break block15;
                        }
                    }
                    catch (Throwable var4_8) {
                        var5_4 = null;
                        if (is == null) throw var4_8;
                        ** try [egrp 2[TRYBLOCK] [2 : 73->80)] { 
lbl31:
                        // 1 sources

                        is.close();
                        throw var4_8;
lbl33:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                        throw var4_8;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 73->80)] { 
lbl38:
                    // 1 sources

                    is.close();
                    return var6_7;
lbl40:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var6_7;
                }
                var5_4 = null;
                if (is != null) {
                    try {}
                    catch (IOException ioe) {}
                    is.close();
                }
            }
            ++i;
        }
    }
}

