/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";
    private String interpolateimage = "";

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.interpolate = Runtime.getBoolean("runtime.interpolate.string.literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf("$") != -1 || this.getFirstToken().image.indexOf("#") != -1);
        this.image = this.getFirstToken().image.substring(1, this.getFirstToken().image.length() - 1);
        this.interpolateimage = this.image + " ";
        return data;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(InternalContextAdapter context) {
        if (this.interpolate) {
            try {
                if (this.nodeTree == null) {
                    BufferedReader br = new BufferedReader(new StringReader(this.interpolateimage));
                    this.nodeTree = Runtime.parse(br, context.getCurrentTemplateName());
                    this.nodeTree.init(context, null);
                }
                StringWriter writer = new StringWriter();
                this.nodeTree.render(context, writer);
                String ret = writer.toString();
                return ret.substring(0, ret.length() - 1);
            }
            catch (Exception e) {
                Runtime.error("Error in interpolating string literal : " + e);
            }
        }
        return this.image;
    }

    public ASTStringLiteral(int id) {
        super(id);
    }

    public ASTStringLiteral(Parser p, int id) {
        super(p, id);
    }
}

