/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.net.SyslogAppender;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.log.LogSystem;

public class Log4JLogSystem
implements LogSystem {
    protected Category logger = null;
    protected Layout layout = null;
    private String logfile = Runtime.getString("runtime.log");

    public void init() throws Exception {
        this.logger = Category.getInstance((String)"");
        this.logger.setAdditivity(false);
        this.logger.setPriority(Priority.DEBUG);
        String pattern = Runtime.getString("runtime.log.logsystem.log4j.pattern");
        if (pattern == null || pattern.length() == 0) {
            pattern = "%d - %m%n";
        }
        this.layout = new PatternLayout(pattern);
        this.configureFile();
        this.configureRemote();
        this.configureSyslog();
        this.configureEmail();
    }

    private void configureFile() throws Exception {
        int backupFiles = Runtime.getInt("runtime.log.logsystem.log4j.file.backups", 1);
        int fileSize = Runtime.getInt("runtime.log.logsystem.log4j.file.size", 100000);
        RollingFileAppender appender = new RollingFileAppender(this.layout, this.logfile, true);
        appender.setMaxBackupIndex(backupFiles);
        if (fileSize > -1) {
            appender.setMaxFileSize((long)fileSize);
        }
        this.logger.addAppender((Appender)appender);
    }

    private void configureRemote() throws Exception {
        String remoteHost = Runtime.getString("runtime.log.logsystem.log4j.remote.host");
        int remotePort = Runtime.getInt("runtime.log.logsystem.log4j.remote.port", 1099);
        if (remoteHost == null || remoteHost.trim().equals("") || remotePort <= 0) {
            return;
        }
        SocketAppender appender = new SocketAppender(remoteHost, remotePort);
        this.logger.addAppender((Appender)appender);
    }

    private void configureSyslog() throws Exception {
        String syslogHost = Runtime.getString("runtime.log.logsystem.log4j.syslogd.host");
        String syslogFacility = Runtime.getString("runtime.log.logsystem.log4j.syslogd.facility");
        if (syslogHost == null || syslogHost.trim().equals("") || syslogFacility == null) {
            return;
        }
        SyslogAppender appender = new SyslogAppender();
        appender.setLayout(this.layout);
        appender.setSyslogHost(syslogHost);
        appender.setFacility(syslogFacility);
        this.logger.addAppender((Appender)appender);
    }

    private void configureEmail() throws Exception {
        String smtpHost = Runtime.getString("runtime.log.logsystem.log4j.email.server");
        String emailFrom = Runtime.getString("runtime.log.logsystem.log4j.email.from");
        String emailTo = Runtime.getString("runtime.log.logsystem.log4j.email.to");
        String emailSubject = Runtime.getString("runtime.log.logsystem.log4j.email.subject");
        String bufferSize = Runtime.getString("runtime.log.logsystem.log4j.email.buffer.size");
        if (smtpHost == null || smtpHost.trim().equals("") || emailFrom == null || smtpHost.trim().equals("") || emailTo == null || emailTo.trim().equals("") || emailSubject == null || emailSubject.trim().equals("") || bufferSize == null || bufferSize.trim().equals("")) {
            return;
        }
        SMTPAppender appender = new SMTPAppender();
        appender.setOption("SMTPHost", smtpHost);
        appender.setOption("From", emailFrom);
        appender.setOption("To", emailTo);
        appender.setOption("Subject", emailSubject);
        appender.setOption("BufferSize", bufferSize);
        appender.setLayout(this.layout);
        appender.activateOptions();
        this.logger.addAppender((Appender)appender);
    }

    public void logVelocityMessage(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn((Object)message);
                break;
            }
            case 1: {
                this.logger.info((Object)message);
                break;
            }
            case 0: {
                this.logger.debug((Object)message);
                break;
            }
            case 3: {
                this.logger.error((Object)message);
                break;
            }
            default: {
                this.logger.debug((Object)message);
                break;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        Enumeration appenders = this.logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appender.close();
        }
    }

    public Log4JLogSystem() {
        try {
            this.init();
            this.logVelocityMessage(0, "Log4JLogSystem initialized using logfile " + this.logfile);
        }
        catch (Exception e) {
            System.out.println("PANIC : error configuring Log4JLogSystem : " + e);
        }
    }
}

