/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.Resource;

public class Include
extends Directive {
    private String outputMsgStart = "";
    private String outputMsgEnd = "";

    public String getName() {
        return "include";
    }

    public int getType() {
        return 2;
    }

    public void init(InternalContextAdapter context, Node node) throws Exception {
        super.init(context, node);
        this.outputMsgStart = Runtime.getString("directive.include.output.errormsg.start");
        this.outputMsgStart = this.outputMsgStart + " ";
        this.outputMsgEnd = Runtime.getString("directive.include.output.errormsg.end");
        this.outputMsgEnd = " " + this.outputMsgEnd;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException {
        int argCount = node.jjtGetNumChildren();
        int i = 0;
        while (i < argCount) {
            Node n = node.jjtGetChild(i);
            if (n.getType() == 6 || n.getType() == 14) {
                if (!this.renderOutput(n, context, writer)) {
                    this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
                }
            } else {
                Runtime.error("#include() error : invalid argument type : " + n.toString());
                this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
            }
            ++i;
        }
        return true;
    }

    private boolean renderOutput(Node node, InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        String arg = "";
        if (node == null) {
            Runtime.error("#include() error :  null argument");
            return false;
        }
        Object value = node.value(context);
        if (value == null) {
            Runtime.error("#include() error :  null argument");
            return false;
        }
        arg = value.toString();
        ContentResource resource = null;
        Resource current = context.getCurrentResource();
        try {
            resource = Runtime.getContent(arg, current.getEncoding());
        }
        catch (Exception e) {
            Runtime.error("#include : cannot find " + arg + " template!");
        }
        if (resource == null) {
            return false;
        }
        writer.write((String)resource.getData());
        return true;
    }

    private void outputErrorToStream(Writer writer, String msg) throws IOException {
        if (this.outputMsgStart != null && this.outputMsgEnd != null) {
            writer.write(this.outputMsgStart);
            writer.write(msg);
            writer.write(this.outputMsgEnd);
        }
    }
}

