/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.Vector;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.VelocimacroManager;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.VelocimacroProxy;

public class VelocimacroFactory {
    private VelocimacroManager vmManager = new VelocimacroManager();
    private boolean replaceAllowed = false;
    private boolean addNewAllowed = true;
    private boolean templateLocal = false;
    private boolean blather = false;

    public void initVelocimacro() {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.setReplacementPermission(true);
            this.setBlather(true);
            this.logVMMessageInfo("Velocimacro : initialization starting.");
            this.vmManager.setNamespaceUsage(false);
            Object libfiles = Runtime.getProperty("velocimacro.library");
            if (libfiles != null) {
                Vector v = new Vector();
                if (libfiles instanceof Vector) {
                    v = (Vector)libfiles;
                } else if (libfiles instanceof String) {
                    v.addElement(libfiles);
                }
                int i = 0;
                while (i < v.size()) {
                    String lib = (String)v.elementAt(i);
                    try {
                        this.logVMMessageInfo("Velocimacro : adding VMs from VM library template : " + lib);
                        Template template = Runtime.getTemplate(lib);
                        this.logVMMessageInfo("Velocimacro :  VM library template macro registration complete.");
                    }
                    catch (Exception e) {
                        this.logVMMessageInfo("Velocimacro : error using  VM library template " + lib + " : " + e);
                    }
                    ++i;
                }
            }
            this.setAddMacroPermission(true);
            if (!Runtime.getBoolean("velocimacro.permissions.allow.inline", true)) {
                this.setAddMacroPermission(false);
                this.logVMMessageInfo("Velocimacro : allowInline = false : VMs can not be defined inline in templates");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInline = true : VMs can be defined inline in templates");
            }
            this.setReplacementPermission(false);
            if (Runtime.getBoolean("velocimacro.permissions.allow.inline.to.replace.global", false)) {
                this.setReplacementPermission(true);
                this.logVMMessageInfo("Velocimacro : allowInlineToOverride = true : VMs defined inline may replace previous VM definitions");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInlineToOverride = false : VMs defined inline may NOT replace previous VM definitions");
            }
            this.vmManager.setNamespaceUsage(true);
            this.setTemplateLocalInline(Runtime.getBoolean("velocimacro.permissions.allow.inline.local.scope", false));
            if (this.getTemplateLocalInline()) {
                this.logVMMessageInfo("Velocimacro : allowInlineLocal = true : VMs defined inline will be local to their defining template only.");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInlineLocal = false : VMs defined inline will be  global in scope if allowed.");
            }
            this.vmManager.setTemplateLocalInlineVM(this.getTemplateLocalInline());
            this.setBlather(Runtime.getBoolean("velocimacro.messages.on", true));
            if (this.getBlather()) {
                this.logVMMessageInfo("Velocimacro : messages on  : VM system will output logging messages");
            } else {
                Runtime.info("Velocimacro : messages off : VM system will be quiet");
            }
            Runtime.info("Velocimacro : initialization complete.");
        }
    }

    public boolean addVelocimacro(String name, String macroBody, String[] argArray, String sourceTemplate) {
        if (name == null || macroBody == null || argArray == null || sourceTemplate == null) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : programmer error : arg null");
            return false;
        }
        if (!this.addNewAllowed) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : " + name + " : inline VMs not allowed.");
            return false;
        }
        if (!this.templateLocal && this.isVelocimacro(name, sourceTemplate) && !this.replaceAllowed) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : " + name + " : inline not allowed to replace existing VM");
            return false;
        }
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.vmManager.addVM(name, macroBody, argArray, sourceTemplate);
        }
        if (this.blather) {
            String s = "#" + argArray[0];
            s = s + "(";
            int i = 1;
            while (i < argArray.length) {
                s = s + " ";
                s = s + argArray[i];
                ++i;
            }
            s = s + " ) : source = ";
            s = s + sourceTemplate;
            this.logVMMessageInfo("Velocimacro : added new VM : " + s);
        }
        return true;
    }

    private void logVMMessageInfo(String s) {
        if (this.blather) {
            Runtime.info(s);
        }
    }

    private void logVMMessageWarn(String s) {
        if (this.blather) {
            Runtime.warn(s);
        }
    }

    public boolean isVelocimacro(String vm, String sourceTemplate) {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            if (this.vmManager.get(vm, sourceTemplate) != null) {
                boolean bl = true;
                Object var4_5 = null;
                return bl;
            }
        }
        return false;
    }

    public Directive getVelocimacro(String vmName, String sourceTemplate) {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            if (this.isVelocimacro(vmName, sourceTemplate)) {
                VelocimacroProxy velocimacroProxy = this.vmManager.get(vmName, sourceTemplate);
                Object var4_5 = null;
                return velocimacroProxy;
            }
        }
        return null;
    }

    public boolean dumpVMNamespace(String namespace) {
        return this.vmManager.dumpNamespace(namespace);
    }

    private void setTemplateLocalInline(boolean b) {
        this.templateLocal = b;
    }

    private boolean getTemplateLocalInline() {
        return this.templateLocal;
    }

    private boolean setAddMacroPermission(boolean arg) {
        boolean b = this.addNewAllowed;
        this.addNewAllowed = arg;
        return b;
    }

    private boolean setReplacementPermission(boolean arg) {
        boolean b = this.replaceAllowed;
        this.replaceAllowed = arg;
        return b;
    }

    private void setBlather(boolean b) {
        this.blather = b;
    }

    private boolean getBlather() {
        return this.blather;
    }
}

