/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.LogManager;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.SimplePool;
import org.apache.velocity.util.StringUtils;

public class Runtime
implements RuntimeConstants {
    private static VelocimacroFactory vmFactory = new VelocimacroFactory();
    private static LogSystem logSystem = null;
    private static Hashtable globalCache;
    private static SimplePool parserPool;
    private static boolean initialized;
    private static ExtendedProperties overridingProperties;
    private static Vector pendingMessages;
    private static Hashtable runtimeDirectives;
    private static ExtendedProperties configuration;
    private static /* synthetic */ Class class$Lorg$apache$velocity$runtime$Runtime;

    public static synchronized void init() throws Exception {
        if (!initialized) {
            try {
                Runtime.initializeProperties();
                Runtime.initializeLogger();
                ResourceManager.initialize();
                Runtime.initializeDirectives();
                Runtime.initializeParserPool();
                Runtime.initializeGlobalCache();
                vmFactory.initVelocimacro();
                Runtime.info("Velocity successfully started.");
                initialized = true;
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    private static void setDefaultProperties() {
        ClassLoader classLoader = (class$Lorg$apache$velocity$runtime$Runtime != null ? class$Lorg$apache$velocity$runtime$Runtime : (class$Lorg$apache$velocity$runtime$Runtime = Runtime.class$("org.apache.velocity.runtime.Runtime"))).getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream("org/apache/velocity/runtime/defaults/velocity.properties");
            configuration.load(inputStream);
            Runtime.info("Default Properties File: " + new File("org/apache/velocity/runtime/defaults/velocity.properties").getPath());
        }
        catch (IOException ioe) {
            System.err.println("Cannot get Velocity Runtime default properties!");
        }
    }

    public static void setProperty(String key, Object value) {
        if (overridingProperties == null) {
            overridingProperties = new ExtendedProperties();
        }
        overridingProperties.setProperty(key, value);
    }

    public static void setConfiguration(ExtendedProperties configuration) {
        if (overridingProperties == null) {
            overridingProperties = configuration;
        } else {
            overridingProperties.combine(configuration);
        }
    }

    public static void addProperty(String key, Object value) {
        if (overridingProperties == null) {
            overridingProperties = new ExtendedProperties();
        }
        overridingProperties.addProperty(key, value);
    }

    public static void clearProperty(String key) {
        if (overridingProperties != null) {
            overridingProperties.clearProperty(key);
        }
    }

    public static Object getProperty(String key) {
        return configuration.getProperty(key);
    }

    private static void initializeProperties() {
        if (!configuration.isInitialized()) {
            Runtime.setDefaultProperties();
        }
        if (overridingProperties != null) {
            configuration.combine(overridingProperties);
        }
    }

    public static void init(Properties p) throws Exception {
        overridingProperties = ExtendedProperties.convertProperties(p);
        Runtime.init();
    }

    public static void init(String configurationFile) throws Exception {
        overridingProperties = new ExtendedProperties(configurationFile);
        Runtime.init();
    }

    private static void initializeLogger() throws Exception {
        if (logSystem == null) {
            logSystem = LogManager.createLogSystem();
        }
        Runtime.dumpPendingMessages();
    }

    private static void dumpPendingMessages() {
        if (!pendingMessages.isEmpty()) {
            Enumeration e = pendingMessages.elements();
            while (e.hasMoreElements()) {
                Object[] data = (Object[])e.nextElement();
                Runtime.log((Integer)data[0], data[1]);
            }
            pendingMessages = new Vector();
        }
    }

    private static void initializeDirectives() throws Exception {
        runtimeDirectives = new Hashtable();
        Properties directiveProperties = new Properties();
        ClassLoader classLoader = (class$Lorg$apache$velocity$runtime$Runtime != null ? class$Lorg$apache$velocity$runtime$Runtime : (class$Lorg$apache$velocity$runtime$Runtime = Runtime.class$("org.apache.velocity.runtime.Runtime"))).getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/velocity/runtime/defaults/directive.properties");
        if (inputStream == null) {
            throw new Exception("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
        }
        directiveProperties.load(inputStream);
        Enumeration directiveClasses = ((Hashtable)directiveProperties).elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            try {
                Class<?> clazz = Class.forName(directiveClass);
                Directive directive = (Directive)clazz.newInstance();
                runtimeDirectives.put(directive.getName(), directive);
                Runtime.info("Loaded Pluggable Directive: " + directiveClass);
            }
            catch (Exception e) {
                Runtime.error("Error Loading Pluggable Directive: " + directiveClass);
            }
        }
    }

    private static void initializeParserPool() {
        int numParsers = Runtime.getInt("parser.pool.size", 20);
        parserPool = new SimplePool(numParsers);
        int i = 0;
        while (i < numParsers) {
            parserPool.put(Runtime.createNewParser());
            ++i;
        }
        Runtime.info("Created: " + numParsers + " parsers.");
    }

    public static Parser createNewParser() {
        Parser parser = new Parser();
        parser.setDirectives(runtimeDirectives);
        return parser;
    }

    public static SimpleNode parse(Reader reader, String templateName) throws ParseException {
        SimpleNode ast = null;
        Parser parser = (Parser)parserPool.get();
        boolean madeNew = false;
        if (parser == null) {
            Runtime.error("Runtime : ran out of parsers. Creating new.   Please increment the parser.pool.size property. The current value is too small.");
            parser = Runtime.createNewParser();
            if (parser != null) {
                madeNew = true;
            }
        }
        if (parser != null) {
            try {
                ast = parser.parse(reader, templateName);
            }
            finally {
                Object var6_5 = null;
                if (!madeNew) {
                    parserPool.put(parser);
                }
            }
        } else {
            Runtime.error("Runtime : ran out of parsers and unable to create more.");
        }
        return ast;
    }

    private static void initializeGlobalCache() {
        globalCache = new Hashtable();
    }

    public static Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return Runtime.getTemplate(name, Runtime.getString("input.encoding", "ISO-8859-1"));
    }

    public static Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (Template)ResourceManager.getResource(name, 1, encoding);
    }

    public static ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return Runtime.getContent(name, Runtime.getString("input.encoding", "ISO-8859-1"));
    }

    public static ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return (ContentResource)ResourceManager.getResource(name, 2, encoding);
    }

    public static String getLoaderNameForResource(String resourceName) {
        return ResourceManager.getLoaderNameForResource(resourceName);
    }

    private static boolean showStackTrace() {
        if (configuration.isInitialized()) {
            return Runtime.getBoolean("runtime.log.warn.stacktrace", false);
        }
        return false;
    }

    private static void log(int level, Object message) {
        String out = "";
        switch (level) {
            case 0: {
                out = " [debug] ";
                break;
            }
            case 1: {
                out = "  [info] ";
                break;
            }
            case 2: {
                out = "  [warn] ";
                break;
            }
            case 3: {
                out = " [error] ";
                break;
            }
            default: {
                out = " [unknown] ";
                break;
            }
        }
        out = Runtime.showStackTrace() && (message instanceof Throwable || message instanceof Exception) ? out + StringUtils.stackTrace((Throwable)message) : out + message.toString();
        if (logSystem != null) {
            logSystem.logVelocityMessage(level, out);
        } else {
            Object[] data = new Object[]{new Integer(level), out};
            pendingMessages.addElement(data);
        }
    }

    public static void warn(Object message) {
        Runtime.log(2, message);
    }

    public static void info(Object message) {
        Runtime.log(1, message);
    }

    public static void error(Object message) {
        Runtime.log(3, message);
    }

    public static void debug(Object message) {
        Runtime.log(0, message);
    }

    public static String getString(String key, String defaultValue) {
        return configuration.getString(key, defaultValue);
    }

    public static Directive getVelocimacro(String vmName, String templateName) {
        return vmFactory.getVelocimacro(vmName, templateName);
    }

    public static boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        return vmFactory.addVelocimacro(name, macro, argArray, sourceTemplate);
    }

    public static boolean isVelocimacro(String vmName, String templateName) {
        return vmFactory.isVelocimacro(vmName, templateName);
    }

    public static boolean dumpVMNamespace(String namespace) {
        return vmFactory.dumpVMNamespace(namespace);
    }

    public static String getString(String key) {
        return configuration.getString(key);
    }

    public static int getInt(String key) {
        return configuration.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return configuration.getInt(key, defaultValue);
    }

    public static boolean getBoolean(String key, boolean def) {
        return configuration.getBoolean(key, def);
    }

    public static ExtendedProperties getConfiguration() {
        return configuration;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        overridingProperties = null;
        pendingMessages = new Vector();
        configuration = new ExtendedProperties();
    }
}

