/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.convert;

import java.io.File;
import java.io.FileWriter;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.velocity.util.StringUtils;

public class WebMacro {
    protected static final String VM_EXT = ".vm";
    protected static final String WM_EXT = ".wm";
    protected static String[] perLineREs = new String[]{"#if\\s*[(]\\s*(.*\\S)\\s*[)]\\s*(#begin|{)[ \\t]?", "#if( $1 )", "[ \\t]?(#end|})[ \\t]*\n(\\s*)#else\\s*(#begin|{)[ \\t]?(\\w)", "$2#else#**#$4", "[ \\t]?(#end|})[ \\t]*\n(\\s*)#else\\s*(#begin|{)[ \\t]?", "$2#else", "(#end|})(\\s*#else)\\s*(#begin|{)[ \\t]?", "$1\n$2", "#foreach\\s+(\\$\\w+)\\s+in\\s+(\\$[^\\s#]+)\\s*(#begin|{)[ \\t]?", "#foreach( $1 in $2 )", "#set\\s+(\\$[^\\s=]+)\\s*=\\s*([\\S]+)[ \\t]*", "#set( $1 = $2 )", "(##[# \\t\\w]*)\\)", ")$1", "#parse\\s+([^\\s#]+)[ \\t]?", "#parse( $1 )", "#include\\s+([^\\s#]+)[ \\t]?", "#include( $1 )", "\\$\\(([^\\)]+)\\)", "${$1}", "\\${([^}\\(]+)\\(([^}]+)}\\)", "${$1($2)}", "\\$_", "$l_", "\\${(_[^}]+)}", "${l$1}", "(#set\\s*\\([^;]+);(\\s*\\))", "$1$2", "(^|[^\\\\])\\$(\\w[^=\n;]*);", "$1${$2}", "\\.wm", ".vm"};

    public void convert(String target) {
        File file = new File(target);
        if (!file.exists()) {
            System.err.println("The specified template or directory does not exist");
            System.exit(1);
        }
        if (file.isDirectory()) {
            String basedir = file.getAbsolutePath();
            String newBasedir = basedir + VM_EXT;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                this.writeTemplate(files[i], basedir, newBasedir);
                ++i;
            }
        } else {
            this.writeTemplate(file.getAbsolutePath(), "", "");
        }
    }

    private boolean writeTemplate(String file, String basedir, String newBasedir) {
        String newTemplate;
        String template;
        if (file.indexOf(WM_EXT) < 0) {
            return false;
        }
        System.out.println("Converting " + file + "...");
        if (basedir.length() == 0) {
            template = file;
            String templateDir = "";
            String string = this.convertName(file);
        } else {
            template = basedir + File.separator + file;
            String templateDir = newBasedir + this.extractPath(file);
            File outputDirectory = new File(templateDir);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            newTemplate = newBasedir + File.separator + this.convertName(file);
        }
        String convertedTemplate = this.convertTemplate(template);
        try {
            FileWriter fw = new FileWriter(newTemplate);
            fw.write(convertedTemplate);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private final String extractPath(String file) {
        int lastSepPos = file.lastIndexOf(File.separator);
        return lastSepPos == -1 ? "" : File.separator + file.substring(0, lastSepPos);
    }

    private String convertName(String name) {
        if (name.indexOf(WM_EXT) > 0) {
            return name.substring(0, name.indexOf(WM_EXT)) + VM_EXT;
        }
        return name;
    }

    private static final void usage() {
        System.err.println("Usage: convert-wm <template.wm | directory>");
        System.exit(1);
    }

    public String convertTemplate(String template) {
        String contents = StringUtils.fileContentsToString(template);
        if (!contents.endsWith("\n")) {
            contents = contents + "\n";
        }
        Perl5Util perl = new Perl5Util();
        int i = 0;
        while (i < perLineREs.length) {
            contents = perl.substitute(this.makeSubstRE(i), contents);
            i += 2;
        }
        if (perl.match("m/javascript/i", contents)) {
            contents = perl.substitute("s/\n}/\n#end/g", contents);
        } else {
            contents = perl.substitute("s/(\n\\s*)}/$1#end/g", contents);
            contents = perl.substitute("s/#end\\s*\n\\s*#else/#else/g", contents);
        }
        return contents;
    }

    private final String makeSubstRE(int i) {
        return "s/" + perLineREs[i] + "/" + perLineREs[i + 1] + "/g";
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            WebMacro converter = new WebMacro();
            converter.convert(args[0]);
        } else {
            WebMacro.usage();
        }
    }
}

