/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.configuration.Configuration;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class Velocity
implements RuntimeConstants {
    public static void init() throws Exception {
        Runtime.init();
    }

    public static void init(String propsFilename) throws Exception {
        Runtime.init(propsFilename);
    }

    public static void init(Properties p) throws Exception {
        Runtime.init(p);
    }

    public static void setProperty(String key, Object value) {
        Runtime.setProperty(key, value);
    }

    public static void addProperty(String key, Object value) {
        Runtime.addProperty(key, value);
    }

    public static void clearProperty(String key) {
        Runtime.clearProperty(key);
    }

    public static void setConfiguration(Configuration configuration) {
        ExtendedProperties ep = configuration.getExtendedProperties();
        Runtime.setConfiguration(ep);
    }

    public static void setExtendedProperties(ExtendedProperties configuration) {
        Runtime.setConfiguration(configuration);
    }

    public static Object getProperty(String key) {
        return Runtime.getProperty(key);
    }

    public static boolean evaluate(Context context, Writer out, String logTag, String instring) throws ParseErrorException, MethodInvocationException, IOException {
        return Velocity.evaluate(context, out, logTag, new BufferedReader(new StringReader(instring)));
    }

    public static boolean evaluate(Context context, Writer writer, String logTag, InputStream instream) throws ParseErrorException, MethodInvocationException, IOException {
        BufferedReader br = null;
        String encoding = null;
        try {
            encoding = Runtime.getString("input.encoding", "ISO-8859-1");
            br = new BufferedReader(new InputStreamReader(instream, encoding));
        }
        catch (UnsupportedEncodingException uce) {
            String msg = "Unsupported input encoding : " + encoding + " for template " + logTag;
            throw new ParseErrorException(msg);
        }
        return Velocity.evaluate(context, writer, logTag, br);
    }

    public static boolean evaluate(Context context, Writer writer, String logTag, Reader reader) throws ParseErrorException, MethodInvocationException, IOException {
        SimpleNode nodeTree = null;
        try {
            nodeTree = Runtime.parse(reader, logTag);
        }
        catch (ParseException pex) {
            throw new ParseErrorException(pex.getMessage());
        }
        if (nodeTree != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
            ica.pushCurrentTemplateName(logTag);
            try {
                try {
                    nodeTree.init(ica, null);
                }
                catch (Exception e) {
                    Runtime.error("Velocity.evaluate() : init exception for tag = " + logTag + " : " + e);
                }
                nodeTree.render(ica, writer);
            }
            finally {
                Object var7_8 = null;
                ica.popCurrentTemplateName();
            }
            return true;
        }
        return false;
    }

    public static boolean invokeVelocimacro(String vmName, String namespace, String[] params, Context context, Writer writer) {
        if (vmName == null || params == null || context == null || writer == null || namespace == null) {
            Runtime.error("Velocity.invokeVelocimacro() : invalid parameter");
            return false;
        }
        if (!Runtime.isVelocimacro(vmName, namespace)) {
            Runtime.error("Velocity.invokeVelocimacro() : VM '" + vmName + "' not registered.");
            return false;
        }
        VelocimacroProxy vp = (VelocimacroProxy)Runtime.getVelocimacro(vmName, namespace);
        if (vp == null) {
            Runtime.error("Velocity.invokeVelocimacro() : VM '" + vmName + "' : severe error.  Unable to get VM from factory.");
            return false;
        }
        if (vp.getNumArgs() > params.length) {
            Runtime.error("Velocity.invokeVelocimacro() : VM '" + vmName + "' : invalid # of args.  Needed " + vp.getNumArgs() + " but called with " + params.length);
            return false;
        }
        int[] types = new int[vp.getNumArgs()];
        String[] p = new String[vp.getNumArgs()];
        int i = 0;
        while (i < types.length) {
            types[i] = 14;
            p[i] = "$" + params[i];
            ++i;
        }
        vp.setupMacro(p, types);
        try {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
            try {
                ica.pushCurrentTemplateName(namespace);
                vp.render(ica, writer, null);
            }
            finally {
                Object var10_11 = null;
                ica.popCurrentTemplateName();
            }
        }
        catch (Exception e) {
            Runtime.error("Velocity.invokeVelocimacro() : " + e);
            return false;
        }
        return true;
    }

    public static boolean mergeTemplate(String templateName, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        return Velocity.mergeTemplate(templateName, Runtime.getString("input.encoding", "ISO-8859-1"), context, writer);
    }

    public static boolean mergeTemplate(String templateName, String encoding, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        Template template = Runtime.getTemplate(templateName, encoding);
        if (template == null) {
            Runtime.error("Velocity.parseTemplate() failed loading template '" + templateName + "'");
            return false;
        }
        template.merge(context, writer);
        return true;
    }

    public static Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return Runtime.getTemplate(name);
    }

    public static Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return Runtime.getTemplate(name, encoding);
    }

    public static boolean templateExists(String templateName) {
        return Runtime.getLoaderNameForResource(templateName) != null;
    }
}

