/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FilterSet;

public class FileUtils {
    private static Object lockReflection = new Object();
    private static Method setLastModified = null;
    static /* synthetic */ Class class$java$io$File;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    protected FileUtils() {
    }

    public void copyFile(String string, String string2) throws IOException {
        this.copyFile(new File(string), new File(string2), null, false, false);
    }

    public void copyFile(String string, String string2, FilterSet filterSet) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSet, false, false);
    }

    public void copyFile(String string, String string2, FilterSet filterSet, boolean bl) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSet, bl, false);
    }

    public void copyFile(String string, String string2, FilterSet filterSet, boolean bl, boolean bl2) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSet, bl, bl2);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.copyFile(file, file2, null, false, false);
    }

    public void copyFile(File file, File file2, FilterSet filterSet) throws IOException {
        this.copyFile(file, file2, filterSet, false, false);
    }

    public void copyFile(File file, File file2, FilterSet filterSet, boolean bl) throws IOException {
        this.copyFile(file, file2, filterSet, bl, false);
    }

    public void copyFile(File file, File file2, FilterSet filterSet, boolean bl, boolean bl2) throws IOException {
        if (bl || !file2.exists() || file2.lastModified() < file.lastModified()) {
            File file3;
            if (file2.exists() && file2.isFile()) {
                file2.delete();
            }
            if (!(file3 = new File(file2.getParent())).exists()) {
                file3.mkdirs();
            }
            if (filterSet != null && filterSet.hasFilters()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                String string = null;
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.length() == 0) {
                        bufferedWriter.newLine();
                    } else {
                        string = filterSet.replaceTokens(string2);
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedWriter.close();
                bufferedReader.close();
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                fileInputStream.close();
                fileOutputStream.close();
            }
            if (bl2) {
                this.setFileLastModified(file2, file.lastModified());
            }
        }
    }

    protected final Method getSetLastModified() {
        if (Project.getJavaVersion() == "1.1") {
            return null;
        }
        if (setLastModified == null) {
            Object object = lockReflection;
            synchronized (object) {
                if (setLastModified == null) {
                    try {
                        setLastModified = (class$java$io$File == null ? (class$java$io$File = FileUtils.class$("java.io.File")) : class$java$io$File).getMethod("setLastModified", Long.TYPE);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new BuildException("File.setlastModified not in JDK > 1.1?", noSuchMethodException);
                    }
                }
            }
        }
        return setLastModified;
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        if (Project.getJavaVersion() == "1.1") {
            return;
        }
        Object[] objectArray = new Long[]{l < 0L ? new Long(System.currentTimeMillis()) : new Long(l)};
        try {
            this.getSetLastModified().invoke((Object)file, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
        catch (Throwable throwable) {
            throw new BuildException("Exception setting the modification time of " + file, throwable);
        }
    }

    public File resolveFile(File file, String string) {
        if ((string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(File.separator) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return this.normalize(string);
        }
        if (string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return this.normalize(string);
        }
        File file2 = new File(file.getAbsolutePath());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("..")) {
                String string3 = file2.getParent();
                if (string3 == null) {
                    String string4 = "The file or path you specified (" + string + ") is invalid relative to " + file.getPath();
                    throw new BuildException(string4);
                }
                file2 = new File(string3);
                continue;
            }
            if (string2.equals(".")) continue;
            file2 = new File(file2, string2);
        }
        return new File(file2.getAbsolutePath());
    }

    public File normalize(String string) {
        Object object;
        Object object2;
        String string2 = string;
        if (!((string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(File.separator) || string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':')) {
            String string3 = string + " is not an absolute path";
            throw new BuildException(string3);
        }
        boolean bl = false;
        String string4 = null;
        if (string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            bl = true;
            object2 = string.replace('/', '\\').toCharArray();
            object = new StringBuffer();
            ((StringBuffer)object).append(Character.toUpperCase((char)object2[0])).append(':');
            int n = 2;
            while (n < ((Object)object2).length) {
                if (object2[n] != 92 || object2[n] == 92 && object2[n - 1] != 92) {
                    ((StringBuffer)object).append((char)object2[n]);
                }
                ++n;
            }
            string = ((StringBuffer)object).toString().replace('\\', File.separatorChar);
            if (string.length() == 2) {
                string4 = string;
                string = "";
            } else {
                string4 = string.substring(0, 3);
                string = string.substring(3);
            }
        } else if (string.length() == 1) {
            string4 = File.separator;
            string = "";
        } else if (string.charAt(1) == File.separatorChar) {
            string4 = File.separator + File.separator;
            string = string.substring(2);
        } else {
            string4 = File.separator;
            string = string.substring(1);
        }
        object2 = new Stack<String>();
        ((Stack)object2).push(string4);
        object = new StringTokenizer(string, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string5 = ((StringTokenizer)object).nextToken();
            if (".".equals(string5)) continue;
            if ("..".equals(string5)) {
                if (((Vector)object2).size() < 2) {
                    throw new BuildException("Cannot resolve path " + string2);
                }
                ((Stack)object2).pop();
                continue;
            }
            ((Stack)object2).push(string5);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < ((Vector)object2).size()) {
            if (n > 1) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(((Vector)object2).elementAt(n));
            ++n;
        }
        string = stringBuffer.toString();
        if (bl) {
            string = string.replace('/', '\\');
        }
        return new File(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

