/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations.xml;

import java.io.File;
import java.io.IOException;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.components.ProxyException;
import org.openprivacy.panther.implementations.CacheConstructor;
import org.openprivacy.panther.implementations.CacheNode;
import org.openprivacy.panther.implementations.PantherProxyEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import talon.Assert;
import talon.util.net.URI;

public class FetchHandler
extends DefaultHandler {
    private String uri = "";
    private String local = "";
    private String findLocation = "";
    private String content = "";
    private boolean found = false;
    private String filename = "";
    private long lastModified = 0L;
    private long minCachedInterval = 0L;

    public FetchHandler(String findLocation) throws IOException {
        CacheNode node = CacheConstructor.construct(findLocation);
        this.findLocation = findLocation;
        if (new File(node.getPath()).exists()) {
            try {
                XMLReader xmlr = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                xmlr.setContentHandler(this);
                xmlr.parse(node.getPath());
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new ProxyException(e.getMessage());
            }
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        this.uri = uri;
        this.local = local;
        if (attrs != null && uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("entry")) {
            String location = attrs.getValue("location");
            String filename = attrs.getValue("filename");
            if (location.equals(this.findLocation) && filename != null) {
                this.found = true;
                this.filename = filename;
                this.lastModified = Long.parseLong(attrs.getValue("lastModified"));
                String attr_minCachedInterval = attrs.getValue("minCachedInterval");
                this.minCachedInterval = attr_minCachedInterval != null ? Long.parseLong(attr_minCachedInterval) : 600000L;
                Assert.assert((this.lastModified != 0L ? 1 : 0) != 0, (String)("lastModified may not be 0: " + this.lastModified));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.local = "";
    }

    public boolean found() {
        return this.found;
    }

    public ProxyEntry getProxyEntry() {
        return new PantherProxyEntry(new URI(this.findLocation), this.filename, this.lastModified, this.minCachedInterval);
    }
}

