/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.components.ProxyException;
import org.openprivacy.panther.implementations.PantherProxy;
import org.openprivacy.panther.implementations.xml.UpdateHandler;
import talon.Assert;
import talon.components.Logger;
import talon.resources.Resource;
import talon.util.Log;
import talon.util.net.URI;

public class PantherProxyEntry
implements ProxyEntry {
    private boolean resource = false;
    private long minCachedInterval = 600000L;
    private URI identifier = null;
    private URL fromURL = null;
    private String filename = null;
    private long lastModified = 0L;
    private long lastUpdateAttempt = 0L;
    private String lastMessage;
    private File file = null;
    private Proxy proxy = null;
    private Logger logger = Log.getLogger((Object)this);

    private PantherProxyEntry(URI identifier) {
        this.proxy = PantherProxy.proxyInstance;
        this.identifier = identifier;
    }

    public PantherProxyEntry(URI identifier, Resource resource) throws IOException {
        this(identifier);
        URL location = resource.getURL();
        String slocation = location.toString();
        if (slocation.startsWith("file:")) {
            String filename = slocation.substring("file:".length(), slocation.length());
            this.lastModified = new File(filename).lastModified();
        } else {
            this.lastModified = location.openConnection().getLastModified();
        }
        this.fromURL = location;
    }

    public PantherProxyEntry(URI identifier, String filename, long lastModified, long minCachedInterval) {
        this(identifier);
        this.filename = filename;
        this.file = new File(filename);
        Assert.assert((lastModified != 0L ? 1 : 0) != 0, (String)"lastModified may not be 0");
        this.lastModified = lastModified;
        this.minCachedInterval = minCachedInterval;
    }

    public InputStream getInputStream() throws IOException {
        if (this.fromURL != null) {
            return this.fromURL.openStream();
        }
        return new FileInputStream(this.filename);
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public String getFileLocation() {
        return "file://" + this.filename;
    }

    public File getFile() throws IOException {
        return this.file;
    }

    public boolean hasChanged() {
        try {
            ProxyEntry newEntry = this.proxy.get(this.identifier);
            return this.getLastModified() < newEntry.getLastModified();
        }
        catch (Throwable t) {
            this.logger.error((Object)t);
            return false;
        }
    }

    public long getMinCachedInterval() {
        return this.minCachedInterval;
    }

    public void setMinCachedInterval(long minCachedInterval) {
        this.minCachedInterval = minCachedInterval;
    }

    public void setResource(boolean resource) {
        this.resource = resource;
    }

    public boolean isResource() {
        return this.resource;
    }

    public void save() throws IOException {
        try {
            new UpdateHandler(this.getIdentifier().toString(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)e);
            throw new ProxyException(e.getMessage());
        }
    }
}

