/*
 * Decompiled with CFR 0.152.
 */
package talon.util.net;

import java.io.IOException;
import java.net.URL;

public class URI {
    private String reference = null;
    private boolean isURL = false;

    public URI() {
    }

    public URI(String reference) {
        this.reference = reference;
    }

    public URI(String reference, boolean isURL) {
        this.reference = reference;
        this.isURL = isURL;
    }

    public String toString() {
        return this.reference;
    }

    public boolean equals(Object obj) {
        if (obj.getClass().equals(this.getClass())) {
            URI uri = (URI)obj;
            return uri.toString().equals(this.toString());
        }
        return false;
    }

    public boolean equals(String uri) {
        return this.toString().equals(uri);
    }

    public boolean isURL() {
        return this.isURL;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getScheme() {
        String scheme = null;
        int index = this.reference.indexOf(":");
        if (index != -1) {
            scheme = this.reference.substring(0, index);
        }
        return scheme;
    }

    public URL getURL() throws IOException {
        return new URL(this.toString());
    }

    public URL getResource() throws IOException {
        URL url = this.getClass().getResource(this.toString());
        if (url == null) {
            throw new IOException("Could not find URI as a resource:  " + this.toString());
        }
        System.out.println("Found url: + " + url.toString());
        return url;
    }
}

