/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import talon.ComponentHandle;
import talon.TalonException;
import talon.implementations.FilePropertyManager;
import talon.resources.ResourceMapper;
import talon.util.TalonResources;

public class TalonPropertyManager
extends FilePropertyManager {
    public static final String[] REQUIRED_PROPERTIES = new String[]{"project"};
    public static final String INIT_PROPERTY_PROJECT = "project";
    private String propertyFilename = null;

    public TalonPropertyManager() {
    }

    public TalonPropertyManager(ComponentHandle handle, String project) throws TalonException {
        this.setComponentHandle(handle);
        handle.getInitProperties().setProperty(INIT_PROPERTY_PROJECT, project);
        this.init();
    }

    public void init() throws TalonException {
        String resource = System.getProperty("talon.properties");
        if (resource != null) {
            System.out.println("Loading Talon resource: " + resource);
            try {
                Properties props = new Properties();
                ResourceMapper rm = TalonResources.getInstance().getResourceMapper();
                props.load(rm.getResource(resource).getURL().openStream());
                this.setProperties(props);
                this.propertyFilename = resource;
                return;
            }
            catch (IOException e) {
                throw new TalonException(e);
            }
        }
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        String project = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_PROJECT);
        String[] locations = this.getFileLocations(project);
        String file = null;
        int i = 0;
        while (i < locations.length) {
            if (new File(locations[i]).exists()) {
                file = locations[i];
            }
            ++i;
        }
        if (file == null) {
            throw new TalonException("Unable to find a property file to use.");
        }
        this.propertyFilename = file;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            this.setProperties(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TalonException(e.getMessage());
        }
    }

    private String[] getFileLocations(String project) {
        Vector<String> v = new Vector<String>();
        String prop = project.toUpperCase() + "_PROPERTIES";
        String value = System.getProperty(prop);
        if (value != null) {
            v.addElement(value);
        }
        v.addElement(System.getProperty("user.home") + File.separator + project + ".properties");
        v.addElement(System.getProperty("java.home") + File.separator + project + ".properties");
        v.addElement("/etc/" + project + ".properties");
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }
}

