/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import talon.BaseComponent;
import talon.Component;
import talon.ComponentHandle;
import talon.TalonException;
import talon.components.Logger;

public class SimpleLogger
extends BaseComponent
implements Component,
Logger {
    public static final String[] REQUIRED_PROPERTIES = new String[]{"project"};
    public static final String INIT_PROPERTY_FILE = "file";
    public static final String INIT_PROPERTY_DEBUG = "debug";
    public static final String INIT_PROPERTY_STDERR = "stdout";
    public static final String INIT_PROPERTY_STDOUT = "stdout";
    public static final String INIT_PROPERTY_PROJECT = "project";
    private boolean fileSafe = true;
    private String file = null;
    private PrintWriter fileOutput = null;
    private boolean debug = false;
    private boolean stdout = false;
    private boolean stderr = false;
    private String project = null;

    public SimpleLogger() {
    }

    public SimpleLogger(ComponentHandle handle, boolean debug, boolean stdout, boolean stderr, String project) {
        this.setComponentHandle(handle);
        this.debug = debug;
        this.stdout = stdout;
        this.stderr = stderr;
        this.project = project;
    }

    public void init() throws TalonException {
        this.getComponentHandle().getInitProperties().require(REQUIRED_PROPERTIES);
        this.debug = this.getComponentHandle().getInitProperties().getBoolean(INIT_PROPERTY_DEBUG);
        this.stdout = this.getComponentHandle().getInitProperties().getBoolean("stdout");
        this.stderr = this.getComponentHandle().getInitProperties().getBoolean("stdout");
        this.file = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_FILE);
        this.project = this.getComponentHandle().getInitProperties().getString(INIT_PROPERTY_PROJECT);
    }

    public void message(String message) {
        this.message(null, message);
    }

    public void message(Object source, String message) {
        this.logString(source, this.getLogPrefix() + " -> " + message);
    }

    public void error(String message) {
        this.error(null, message);
    }

    public void error(Object source, String message) {
        this.logString(source, this.getLogPrefix() + " -> ERROR: " + message);
    }

    public void warning(String message) {
        this.warning(null, message);
    }

    public void warning(Object source, String message) {
        this.logString(source, this.getLogPrefix() + " -> WARNING: " + message);
    }

    public void debug(String message) {
        this.debug(null, message);
    }

    public void debug(Object source, String message) {
        if (this.debug) {
            this.logString(source, this.getLogPrefix() + " -> DEBUG: " + message);
        }
    }

    private void logString(String s) {
        this.logString(null, s);
    }

    private void logString(Object source, String s) {
        if (source != null) {
            s = source.getClass().getName() + " : " + s;
        }
        if (this.stdout) {
            System.out.println(s);
        }
        if (this.stderr) {
            System.err.println(s);
        }
        if (this.isFileEnabled()) {
            if (this.fileOutput == null) {
                try {
                    this.fileOutput = new PrintWriter(new FileWriter(this.file, true));
                    this.debug("Logging to disk is enabled: " + this.file);
                }
                catch (Throwable t) {
                    this.fileSafe = false;
                    this.error(t.getMessage());
                }
            }
            this.fileOutput.println(s);
            this.fileOutput.flush();
        }
    }

    private String getLogPrefix() {
        return this.project + " [" + this.getDate() + "]";
    }

    private boolean isFileEnabled() {
        if (!this.fileSafe) {
            return false;
        }
        if (this.file == null) {
            return false;
        }
        File file = new File(this.file);
        boolean exists = file.exists();
        boolean canWrite = file.canWrite();
        boolean bl = this.fileSafe = exists && canWrite;
        if (!exists) {
            this.error("Log file does not exist: " + this.file);
        } else if (!canWrite) {
            this.error("Log file can not be written to: " + this.file);
        }
        return this.fileSafe;
    }

    private String getDate() {
        Calendar cal = Calendar.getInstance();
        StringBuffer date = new StringBuffer("");
        date.append(cal.get(2) + 1);
        date.append("-");
        date.append(cal.get(5));
        date.append("-");
        date.append(cal.get(1));
        date.append("-");
        date.append(cal.get(10) + 1);
        date.append(".");
        int min = cal.get(12);
        if (min < 10) {
            date.append(0);
        }
        date.append(min);
        date.append(".");
        date.append(cal.get(13));
        date.append(".");
        date.append(cal.get(14));
        return date.toString();
    }

    public void error(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bos));
        this.message(bos.toString());
    }
}

