/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.util.Enumeration;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.HandleManager;
import talon.components.PropertyManager;
import talon.implementations.SimpleLogger;
import talon.implementations.TalonPropertyManager;
import talon.util.TalonResources;

public class Initializer {
    public static final String TALON_LOG_DEBUG_KEY = "talon.log.debug";
    public static final String TALON_LOG_STDOUT_KEY = "talon.log.stdout";
    public static final String TALON_LOG_STDERR_KEY = "talon.log.stderr";
    public static final String TALON_PROJECT_KEY = "talon.project";
    public static final String TALON_PROPERTIES_KEY = "talon.properties";
    private static boolean initialized = false;
    private static boolean working = false;

    public static void init() {
        if (Initializer.shouldInitialize()) {
            working = true;
            try {
                String group_name;
                PropertyManager group;
                String project = System.getProperty(TALON_PROJECT_KEY, "talon");
                TalonPropertyManager tpm = new TalonPropertyManager(ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER, project);
                TalonResources.getInstance().setTalonPropertyManager(tpm);
                ComponentFactory.putSingleton(ComponentFactory.TALON_DEFAULT_PROPERTY_MANAGER, tpm);
                SimpleLogger logger = new SimpleLogger(ComponentFactory.TALON_DEFAULT_LOGGER, tpm.getBoolean(TALON_LOG_DEBUG_KEY), tpm.getBoolean(TALON_LOG_STDOUT_KEY), tpm.getBoolean(TALON_LOG_STDERR_KEY), tpm.getString(TALON_PROJECT_KEY));
                ComponentFactory.setLogger(logger);
                ComponentFactory.putSingleton(ComponentFactory.TALON_DEFAULT_LOGGER, logger);
                logger.message("Talon initialized via file " + tpm.getPropertyFilename());
                logger.message(tpm.toString());
                logger.message(((Object)logger).toString());
                logger.message("Creating handles for all deployed components...");
                int i = 0;
                while ((group = tpm.getGroup(group_name = "talon.component." + i)) != null) {
                    logger.debug("Building properties for: " + group_name);
                    ComponentHandle handle = new ComponentHandle();
                    handle.setName(group.getString("talon_name"));
                    handle.setInterface(group.getString("talon_interface"));
                    handle.setImplementation(group.getString("talon_implementation"));
                    handle.setLifetime(group.getString("talon_lifetime"));
                    handle.setDescription(group.getString("talon_description"));
                    Enumeration keys = group.getKeys();
                    while (keys.hasMoreElements()) {
                        String name = (String)keys.nextElement();
                        String value = group.getString(name);
                        logger.debug("\t" + name + " = " + value);
                        handle.getInitProperties().setProperty(name, value);
                    }
                    logger.message(handle.toString());
                    HandleManager.registerComponentHandle(handle);
                    ++i;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean isWorking() {
        return working;
    }

    public static boolean shouldInitialize() {
        return !Initializer.isWorking() && !Initializer.isInitialized();
    }
}

