/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.util.Hashtable;
import talon.Component;
import talon.ComponentHandle;
import talon.HandleManager;
import talon.Initializer;
import talon.TalonException;
import talon.components.Logger;
import talon.components.PropertyManager;
import talon.implementations.SimplePropertyManager;

public class ComponentFactory {
    public static final String LIFETIME_SINGLETON = "singleton";
    public static final String LIFETIME_DEMAND = "demand";
    public static final ComponentHandle TALON_DEFAULT_LOGGER = new ComponentHandle().setName("TALON_DEFAULT_LOGGER").setImplementation(class$talon$implementations$SimpleLogger == null ? (class$talon$implementations$SimpleLogger = ComponentFactory.class$("talon.implementations.SimpleLogger")) : class$talon$implementations$SimpleLogger).setInitProperties(new SimplePropertyManager().setProperty("project", "talon")).setLifetime("singleton");
    public static final ComponentHandle TALON_DEFAULT_PROPERTY_MANAGER = new ComponentHandle().setName("TALON_DEFAULT_PROPERTY_MANAGER").setImplementation(class$talon$implementations$SimplePropertyManager == null ? (class$talon$implementations$SimplePropertyManager = ComponentFactory.class$("talon.implementations.SimplePropertyManager")) : class$talon$implementations$SimplePropertyManager).setInitProperties(new SimplePropertyManager().setProperty("project", "talon")).setLifetime("singleton");
    public static final ComponentHandle LOGGER_INTERFACE_KEY = new ComponentHandle(class$talon$components$Logger == null ? (class$talon$components$Logger = ComponentFactory.class$("talon.components.Logger")) : class$talon$components$Logger);
    public static final ComponentHandle PROPERTY_MANAGER_INTERFACE_KEY = new ComponentHandle(class$talon$components$PropertyManager == null ? (class$talon$components$PropertyManager = ComponentFactory.class$("talon.components.PropertyManager")) : class$talon$components$PropertyManager);
    private static Hashtable singletons = new Hashtable();
    private static Logger logger = null;
    static /* synthetic */ Class class$talon$implementations$SimpleLogger;
    static /* synthetic */ Class class$talon$implementations$SimplePropertyManager;
    static /* synthetic */ Class class$talon$components$Logger;
    static /* synthetic */ Class class$talon$components$PropertyManager;

    public static Component getInstance(Class _class) throws TalonException {
        return ComponentFactory.getInstance(_class.getName());
    }

    public static Component getInstance(String classname) throws TalonException {
        return ComponentFactory.getInstance(new ComponentHandle().setImplementation(classname).setLifetime(LIFETIME_DEMAND));
    }

    public static Component getInstance(ComponentHandle handle) throws TalonException {
        Initializer.init();
        if (handle.getLifetime() == null) {
            handle.setLifetime(LIFETIME_DEMAND);
        }
        ComponentFactory.constrain(handle.getName(), handle, HandleManager.getNameRegistry());
        ComponentFactory.constrain(handle.getImplementation(), handle, HandleManager.getImplementationRegistry());
        if (handle.getImplementation() == null) {
            throw new TalonException("Unable to determine implementation classname.");
        }
        String lifetime = handle.getLifetime();
        if (lifetime.equals(LIFETIME_DEMAND)) {
            return ComponentFactory.getDemandBasedInstance(handle);
        }
        if (lifetime.equals(LIFETIME_SINGLETON)) {
            return ComponentFactory.getSingletonBasedInstance(handle);
        }
        throw new TalonException("Do not know how to create " + handle.toString());
    }

    private static void constrain(String name, ComponentHandle handle, PropertyManager repository) {
        if (name != null && repository.containsKey(name)) {
            ComponentHandle prototype = (ComponentHandle)repository.getProperty(name);
            ComponentFactory.constrain(handle, prototype);
        }
    }

    private static void constrain(ComponentHandle handle, ComponentHandle prototype) {
        if (prototype.getName() != null && handle.getName() == null) {
            handle.setName(prototype.getName());
        }
        if (prototype.getInterface() != null && handle.getInterface() == null) {
            handle.setInterface(prototype.getInterface());
        }
        if (prototype.getImplementation() != null && handle.getImplementation() == null) {
            handle.setImplementation(prototype.getImplementation());
        }
        if (handle.getInitProperties().size() == 0 && prototype.getInitProperties().size() != 0) {
            logger.debug("Handle provided doesn't have any properties.");
            handle.setInitProperties(prototype.getInitProperties());
        }
    }

    private static Component getDemandBasedInstance(ComponentHandle handle) throws TalonException {
        return ComponentFactory.instantiateComponent(handle);
    }

    private static Component getSingletonBasedInstance(ComponentHandle handle) throws TalonException {
        Component comp = (Component)singletons.get(handle);
        if (comp == null) {
            comp = ComponentFactory.instantiateComponent(handle);
            ComponentFactory.putSingleton(handle, comp);
        }
        return comp;
    }

    private static Component instantiateComponent(ComponentHandle handle) throws TalonException {
        try {
            Component comp = (Component)Class.forName(handle.getImplementation()).newInstance();
            comp.setComponentHandle(handle);
            comp.init();
            return comp;
        }
        catch (Throwable t) {
            throw new TalonException(t);
        }
    }

    static void putSingleton(ComponentHandle handle, Component comp) {
        singletons.put(handle, comp);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        ComponentFactory.logger = logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

