/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.openprivacy.panther.implementations.CacheConstructor;
import org.openprivacy.panther.implementations.CacheNode;
import org.openprivacy.panther.implementations.UpdateManager;
import org.openprivacy.panther.implementations.memory.MemoryCache;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import talon.util.StringUtils;

public class UpdateHandler
extends DefaultHandler {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private PrintWriter out = new PrintWriter(this.bos);
    private String updateLocation = "";
    private String mimeType = "text/xml";
    private boolean updated = false;
    private String content = "";
    private String datfile = "";
    private long lastModified = 0L;
    private String currentNamespace = "";
    private String currentElement = "";
    private String currentLocation = "";

    public UpdateHandler(String updateLocation) throws Exception {
        CacheNode node = CacheConstructor.construct(updateLocation);
        this.updateLocation = updateLocation;
        this.content = this.getContent();
        XMLReader xmlr = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        xmlr.setContentHandler(this);
        node.require();
        this.datfile = node.getDirectory() + "/" + System.currentTimeMillis() + ".dat";
        UpdateManager updateManager = UpdateManager.getInstance();
        synchronized (updateManager) {
            FileOutputStream datos = new FileOutputStream(this.datfile);
            datos.write(this.content.getBytes());
            datos.flush();
            datos.close();
            xmlr.parse(node.getPath());
            this.out.flush();
            this.bos.flush();
            node.setIsNew(false);
            FileOutputStream fos = new FileOutputStream(node.getPath());
            fos.write(this.bos.toByteArray());
            fos.flush();
            fos.close();
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        this.currentNamespace = uri;
        this.currentElement = local;
        if (uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("entry") && attrs.getValue("location") != null) {
            String location;
            this.currentLocation = location = attrs.getValue("location");
            if (location.equals(this.updateLocation)) {
                new File(attrs.getValue("filename")).delete();
                return;
            }
        }
        this.out.print('<');
        this.out.print(raw);
        if (attrs != null) {
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                this.out.print(' ');
                this.out.print(attrs.getQName(i));
                this.out.print("=\"");
                this.out.print(this.normalize(attrs.getValue(i)));
                this.out.print('\"');
                ++i;
            }
        }
        this.out.print(" xmlns=\"" + uri + "\"");
        this.out.print('>');
    }

    public void endElement(String uri, String local, String qName) {
        if (!this.updated && uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("cache")) {
            String escapedLocation = StringUtils.replaceAll((String)this.updateLocation, (String)"&", (String)"&amp;");
            this.lastModified = System.currentTimeMillis();
            this.out.print("<entry location=\"" + escapedLocation + "\" " + "lastModified=\"" + this.lastModified + "\" " + "mimeType=\"" + this.mimeType + "\" " + "filename=\"" + this.datfile + "\"/>");
            this.out.println();
        }
        if (!(this.currentNamespace.equals("http://schemas.openprivacy.org/panther/cache") && this.currentElement.equals("entry") && this.currentLocation.equals(this.updateLocation) && local.equals("entry"))) {
            this.out.print("</" + local + ">");
        }
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void characters(char[] ch, int start, int length) {
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private String getContent() throws IOException {
        String location = this.updateLocation;
        if (location.indexOf("?") != -1) {
            String url = this.updateLocation.substring(0, this.updateLocation.indexOf("?"));
            String urlData = this.updateLocation.substring(this.updateLocation.indexOf("?") + 1, this.updateLocation.length());
            urlData = StringUtils.replaceAll((String)urlData, (String)" ", (String)"%20");
            location = url + "?" + urlData;
        }
        InputStream is = new URL(location).openStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[200];
        int readCount = 0;
        while ((readCount = is.read(data)) > 0) {
            bos.write(data, 0, readCount);
        }
        is.close();
        bos.close();
        String content = bos.toString();
        MemoryCache.store(this.updateLocation, content);
        return content;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFilename() {
        return this.datfile;
    }
}

