/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations.xml;

import java.io.File;
import java.io.IOException;
import org.openprivacy.panther.implementations.CacheConstructor;
import org.openprivacy.panther.implementations.CacheNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FetchHandler
extends DefaultHandler {
    private String uri = "";
    private String local = "";
    private String findLocation = "";
    private String content = "";
    private boolean found = false;
    private String filename = "";
    private long lastModified = 0L;

    public FetchHandler(String findLocation) throws IOException {
        CacheNode node = CacheConstructor.construct(findLocation);
        this.findLocation = findLocation;
        if (new File(node.getPath()).exists()) {
            try {
                XMLReader xmlr = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                xmlr.setContentHandler(this);
                xmlr.parse(node.getPath());
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) {
        this.uri = uri;
        this.local = local;
        if (attrs != null && uri.equals("http://schemas.openprivacy.org/panther/cache") && local.equals("entry")) {
            String location = attrs.getValue("location");
            String filename = attrs.getValue("filename");
            if (location.equals(this.findLocation) && filename != null) {
                this.found = true;
                this.filename = filename;
                this.lastModified = Long.parseLong(attrs.getValue("lastModified"));
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.local = "";
    }

    public boolean found() {
        return this.found;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFilename() {
        return this.filename;
    }
}

