/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.IOException;
import java.util.Hashtable;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.implementations.ProxyEntryManager;
import org.openprivacy.panther.implementations.UpdateThread;

public class UpdateManager {
    public static final long REQUIRED_CACHED_PRIOR_UPDATE_MILI = 600000L;
    private static UpdateManager instance = null;
    private Hashtable lastAttempts = new Hashtable();

    public synchronized void update(String location) throws IOException {
        if (this.stale(location)) {
            this.setLastUpdateAttempt(location);
            new UpdateThread(location).start();
        }
    }

    public long getLastUpdateAttempt(String location) {
        if (this.lastAttempts.containsKey(location)) {
            Long l = (Long)this.lastAttempts.get(location);
            return l;
        }
        return -1L;
    }

    public void setLastUpdateAttempt(String location) {
        this.lastAttempts.put(location, new Long(System.currentTimeMillis()));
    }

    public boolean stale(String location) {
        long delta = 0L;
        try {
            ProxyEntry entry = ProxyEntryManager.getInstance().get(location);
            delta = entry.getLastModified() > this.getLastUpdateAttempt(location) ? System.currentTimeMillis() - entry.getLastModified() : System.currentTimeMillis() - this.getLastUpdateAttempt(location);
        }
        catch (IOException e) {
            delta = System.currentTimeMillis() - this.getLastUpdateAttempt(location);
        }
        return delta > 600000L || this.getLastUpdateAttempt(location) == -1L;
    }

    public static UpdateManager getInstance() {
        if (instance == null) {
            instance = new UpdateManager();
        }
        return instance;
    }
}

