/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.IOException;
import java.util.Hashtable;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.implementations.PantherProxyEntry;
import org.openprivacy.panther.implementations.xml.FetchHandler;
import talon.util.net.URI;

public class ProxyEntryManager {
    private Hashtable entries = new Hashtable();
    private static ProxyEntryManager instance = null;

    public ProxyEntry get(String location) throws IOException {
        if (this.entries.containsKey(location)) {
            PantherProxyEntry entry = (PantherProxyEntry)this.entries.get(location);
            this.requireExists(entry);
            return entry;
        }
        FetchHandler fh = new FetchHandler(location);
        if (fh.found()) {
            PantherProxyEntry entry = new PantherProxyEntry(new URI(location), fh.getFilename(), fh.getLastModified());
            ProxyEntryManager.getInstance().set(location, entry);
            this.requireExists(entry);
            return entry;
        }
        throw new IOException("Update just ran, but URL was not in the cache.");
    }

    private void requireExists(PantherProxyEntry entry) throws IOException {
        if (!entry.exists()) {
            throw new IOException("Entry not cached.");
        }
    }

    public void set(String location, ProxyEntry entry) {
        this.entries.put(location, entry);
    }

    public static ProxyEntryManager getInstance() {
        if (instance == null) {
            instance = new ProxyEntryManager();
        }
        return instance;
    }
}

