/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.openprivacy.panther.components.ProxyEntry;
import talon.util.net.URI;

public class PantherProxyEntry
implements ProxyEntry {
    private URI identifier = null;
    private URL fromURL = null;
    private String filename = null;
    private long lastModified = 0L;
    private long lastUpdateAttempt = 0L;
    private String lastMessage;
    private File file = null;

    public PantherProxyEntry(URI identifier, URL location) throws IOException {
        this.identifier = identifier;
        this.lastModified = location.openConnection().getLastModified();
        this.fromURL = location;
    }

    public PantherProxyEntry(URI identifier, String filename, long lastModified) {
        this.identifier = identifier;
        this.filename = filename;
        this.file = new File(filename);
        this.lastModified = lastModified;
    }

    public InputStream getInputStream() throws IOException {
        if (this.fromURL != null) {
            return this.fromURL.openStream();
        }
        return new FileInputStream(this.filename);
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public String getFileLocation() {
        return "file:" + this.filename;
    }

    public boolean hasChanged() {
        return this.getLastModified() < this.file.lastModified();
    }

    public boolean exists() {
        return this.file.exists();
    }
}

