/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.xml;

import java.util.Hashtable;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import talon.util.net.URI;

public class ReptileTransformerFactory {
    private Hashtable proxyEntryCache = new Hashtable();
    private Proxy proxy = ReptileResources.getInstance().getProxy();
    private static ReptileTransformerFactory instance = null;

    public Transformer getTransformer(URI stylesheet) throws ReptileException {
        try {
            XMLReader xmlReader = ReptileParserFactory.getXMLReader();
            Transformer t = this.getTemplates(stylesheet.toString()).newTransformer();
            t.setURIResolver(this.proxy.getURIResolver());
            return t;
        }
        catch (Exception e) {
            throw new ReptileException(e);
        }
    }

    private Templates getTemplates(String stylesheet) throws Exception {
        System.out.println(" FIXME: (debug): getting stylesheet for: " + stylesheet);
        ProxyEntry pe = (ProxyEntry)this.proxyEntryCache.get(stylesheet);
        return this.newTemplates(stylesheet);
    }

    private Templates newTemplates(String stylesheet) throws Exception {
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        InputSource is = new InputSource(this.proxy.get(stylesheet).getInputStream());
        SAXSource source = new SAXSource(xmlReader, is);
        Templates templates = this.newTransformerFactory().newTemplates(source);
        return templates;
    }

    private TransformerFactory newTransformerFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setURIResolver(this.proxy.getURIResolver());
        return tf;
    }

    public static ReptileTransformerFactory getInstance() {
        if (instance == null) {
            instance = new ReptileTransformerFactory();
        }
        return instance;
    }
}

