/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.extensions;

import java.io.IOException;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.reptile.util.ReptileResources;

public class ProxyFunctions {
    private Proxy proxy = ReptileResources.getInstance().getProxy();

    public boolean contains(String location) {
        return this.proxy.contains(location);
    }

    public boolean supports(String location) {
        return this.proxy.supports(location);
    }

    public void update(String location) {
        try {
            this.proxy.update(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFileLocation(String location) {
        if (this.proxy.contains(location)) {
            try {
                return this.proxy.get(location).getFileLocation();
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        return "";
    }

    public String lastmodified(String location) {
        try {
            if (this.proxy.contains(location)) {
                ProxyEntry entry = this.proxy.get(location);
                long lastmodified = (System.currentTimeMillis() - entry.getLastModified()) / 1000L;
                return this.getFormated(lastmodified);
            }
            return "Not currently available";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown: " + e.getMessage();
        }
    }

    public String getFormated(long difference) {
        int hours = (int)Math.floor(difference / 3600L);
        int minutes = (int)Math.floor((difference - (long)(hours * 3600)) / 60L);
        int seconds = (int)difference - hours * 3600 - minutes * 60;
        StringBuffer result = new StringBuffer("");
        if (hours > 0) {
            result.append(hours + " hour(s), ");
        }
        if (minutes > 0) {
            result.append(minutes + " minute(s), ");
        }
        if ((hours > 0 || minutes > 0) && seconds > 0) {
            result.append(" and ");
        }
        result.append(seconds + " second(s) ");
        result.append("ago");
        return result.toString();
    }
}

