/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.data.marks;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.data.Persistable;
import org.openprivacy.reptile.util.ReptileException;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.MarkStoreInitHandler;
import talon.util.net.URI;

public class MarkStore
implements Persistable {
    public static final URI MARKS_RESOURCE = new URI("resource:/xml/users/default/marks.xml");
    public static final String READ = "read";
    private static MarkStore markstore = null;
    private Hashtable hash = new Hashtable();

    public void commit() {
        try {
            Proxy proxy = ReptileResources.getInstance().getProxy();
            PrintStream out = new PrintStream(proxy.getResource(MARKS_RESOURCE).getOutputStream());
            out.print("<marks xmlns=\"");
            out.print("http://schemas.openprivacy.org/reptile/marks");
            out.println("\">");
            Enumeration keys = this.hash.keys();
            while (keys.hasMoreElements()) {
                String location = (String)keys.nextElement();
                out.println("<entry location=\"" + location + "\">");
                Enumeration marks = this.getMarks(location);
                while (marks.hasMoreElements()) {
                    out.println("<mark value=\"" + (String)marks.nextElement() + "\"></mark>");
                }
                out.println("</entry>");
            }
            out.println("</marks>");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init() throws ReptileException {
        System.out.println("Initializing MarkStore...");
        new MarkStoreInitHandler(MARKS_RESOURCE, this);
    }

    public void addMark(String location, String mark) {
        Vector mv = this.getMarksVector(location);
        if (!mv.contains(mark)) {
            mv.addElement(mark);
        }
    }

    public void deleteMark(String location, String mark) {
        this.getMarksVector(location).remove(mark);
    }

    public Enumeration getMarks(String location) {
        return this.getMarksVector(location).elements();
    }

    public boolean isMarked(String location, String mark) {
        return this.getMarksVector(location).contains(mark);
    }

    private Vector getMarksVector(String location) {
        Vector marks = (Vector)this.hash.get(location);
        if (marks == null) {
            marks = new Vector();
            this.hash.put(location, marks);
        }
        return marks;
    }

    public static MarkStore getInstance() throws ReptileException {
        if (markstore == null) {
            markstore = new MarkStore();
            markstore.init();
        }
        return markstore;
    }
}

