/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.cache.sequence;

import java.util.Enumeration;
import java.util.Hashtable;
import org.openprivacy.reptile.SequenceDispatchEntry;
import org.openprivacy.reptile.util.ParameterPasser;

public class SequenceCacheHandle {
    private ParameterPasser params;
    private SequenceDispatchEntry sde;
    private Hashtable resourceModifications = new Hashtable();
    private String uniqueToken = "";

    public SequenceCacheHandle(SequenceDispatchEntry sde, ParameterPasser params) {
        this.params = params;
        this.sde = sde;
        this.computeUniqueToken();
    }

    private void saveResourceModifications() {
    }

    private void computeUniqueToken() {
        StringBuffer buff = new StringBuffer();
        String[] stylesheets = this.sde.getStylesheetStack().getStylesheets();
        int i = 0;
        while (i < stylesheets.length) {
            buff.append(stylesheets[i]);
            ++i;
        }
        buff.append(this.sde.getSkeleton());
        buff.append(this.sde.getName());
        Enumeration keys = this.params.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.params.get(key);
            buff.append(key);
            buff.append(value);
        }
        this.uniqueToken = buff.toString();
    }

    public boolean canUseCachedContent() {
        if (!this.sde.cacheable()) {
            return false;
        }
        return false;
    }

    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            SequenceCacheHandle handle = (SequenceCacheHandle)obj;
            return handle.getSequenceDispatchEntry().equals(this.getSequenceDispatchEntry()) && handle.getParameterPasser().equals(this.getParameterPasser());
        }
        return false;
    }

    public SequenceDispatchEntry getSequenceDispatchEntry() {
        return this.sde;
    }

    public ParameterPasser getParameterPasser() {
        return this.params;
    }
}

