/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.cache.sequence;

import java.util.Hashtable;
import org.openprivacy.reptile.SequenceDispatchEntry;
import org.openprivacy.reptile.cache.sequence.SequenceCacheEntry;
import org.openprivacy.reptile.cache.sequence.SequenceCacheHandle;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileException;

public class SequenceCache {
    private static SequenceCache instance = null;
    public static final boolean ENABLED = true;
    private Hashtable cache = new Hashtable();

    public SequenceCacheEntry fetch(SequenceDispatchEntry sde, ParameterPasser params) throws ReptileException {
        return this.fetch(new SequenceCacheHandle(sde, params));
    }

    public SequenceCacheEntry fetch(SequenceCacheHandle handle) throws ReptileException {
        String sequenceName = handle.getSequenceDispatchEntry().getName();
        if (handle.canUseCachedContent()) {
            if (this.cache.containsKey(handle)) {
                return (SequenceCacheEntry)this.cache.get(handle);
            }
            throw new ReptileException("Sequence is not in the cache: " + sequenceName);
        }
        throw new ReptileException("Sequence is not available or use: " + sequenceName);
    }

    public void store(SequenceCacheHandle handle, SequenceCacheEntry entry) {
        this.cache.put(handle, entry);
    }

    public static SequenceCache getInstance() {
        if (instance == null) {
            instance = new SequenceCache();
        }
        return instance;
    }
}

