/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openprivacy.reptile.actions.Action;
import org.openprivacy.reptile.actions.UpdateReadMarksHandler;
import org.openprivacy.reptile.data.marks.MarkStore;
import org.openprivacy.reptile.extensions.ContentTransformer;
import org.openprivacy.reptile.util.ParameterPasser;
import talon.Assert;

public class UpdateReadMarks
implements Action {
    public static final String OPERATION_KEY = "reptile.feature.read-marks.operation";
    public static final String CONTENT_TYPE_KEY = "reptile.feature.read-marks.contentType";
    public static final String LOCATION_KEY = "reptile.feature.read-marks.location";
    public static final String OPERATION_READ = "read";
    public static final String OPERATION_UNREAD = "unread";

    public void perform(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter(OPERATION_KEY);
        String contentType = request.getParameter(CONTENT_TYPE_KEY);
        String location = request.getParameter(LOCATION_KEY);
        Assert.assert((Object)operation, (String)"operation not found");
        Assert.assert((Object)contentType, (String)"contentType not found");
        Assert.assert((Object)location, (String)"location not found");
        ParameterPasser params = new ParameterPasser(request, response, "urn:subscriptions");
        ContentTransformer ct = new ContentTransformer(params);
        String output = ct.transform(location, contentType, "http://schemas.openprivacy.org/reptile/content-list");
        new UpdateReadMarksHandler(output, operation);
        MarkStore.getInstance().commit();
    }
}

