/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile.actions;

import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openprivacy.reptile.actions.Action;
import org.openprivacy.reptile.extensions.LinkProducer;

public class ActionManager {
    public static boolean exec(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String action = request.getParameter("reptile.action");
            if (action != null) {
                System.out.println("Found action: " + action);
                Action act = (Action)Class.forName("org.openprivacy.reptile.actions." + action).newInstance();
                act.perform(request, response);
                return ActionManager.redirect(request, response);
            }
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
        return false;
    }

    private static boolean redirect(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String nextActionSequence = request.getParameter("reptile.action.next.sequence");
        String nextActionLayer = request.getParameter("reptile.action.next.layer");
        if (nextActionSequence != null) {
            System.out.println(" FIXME: ( debug ): Sending redirect after action.. ");
            LinkProducer link = new LinkProducer(request, nextActionSequence);
            link.include((ServletRequest)request);
            if (nextActionLayer != null) {
                link.value("layer", URLEncoder.encode(nextActionLayer));
            }
            System.out.println(" FIXME: (debug): REDIRECTING TO: " + link.getLink());
            response.sendRedirect(response.encodeURL(link.getLink()));
            return true;
        }
        return false;
    }
}

