/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.reptile;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.reptile.DumpUtil;
import org.openprivacy.reptile.SequenceDispatchEntry;
import org.openprivacy.reptile.StylesheetStack;
import org.openprivacy.reptile.util.ParameterPasser;
import org.openprivacy.reptile.util.ReptileResources;
import org.openprivacy.reptile.xml.ReptileParserFactory;
import org.openprivacy.reptile.xml.ReptileTransformerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import talon.Assert;
import talon.util.TalonResources;
import talon.util.net.URI;

public class StylesheetEngine {
    private static StylesheetEngine instance = null;
    boolean debug = TalonResources.getInstance().getTalonPropertyManager().getBoolean("talon.log.debug");
    String tmpdir = System.getProperty("java.io.tmpdir");
    static /* synthetic */ Class class$org$openprivacy$reptile$util$ParameterPasser;

    public static StylesheetEngine getInstance() {
        if (instance == null) {
            instance = new StylesheetEngine();
        }
        return instance;
    }

    public String transform(SequenceDispatchEntry sde) throws Exception {
        return this.transform(sde, new ParameterPasser());
    }

    public String transform(SequenceDispatchEntry sde, ParameterPasser params) throws Exception {
        Proxy proxy = ReptileResources.getInstance().getProxy();
        Assert.assert((Object)sde.getSkeleton(), (String)"No XML identifier given.");
        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        InputSource is = new InputSource(proxy.get(sde.getSkeleton()).getInputStream());
        SAXSource xml_source = new SAXSource(xmlReader, is);
        int step = 1;
        StylesheetStack ss = sde.getStylesheetStack();
        DumpUtil dumputil = new DumpUtil(this);
        while (!ss.empty()) {
            URI stylesheetURI = ss.pop();
            Transformer t = ReptileTransformerFactory.getInstance().getTransformer(stylesheetURI);
            t.setParameter((class$org$openprivacy$reptile$util$ParameterPasser == null ? StylesheetEngine.class$("org.openprivacy.reptile.util.ParameterPasser") : class$org$openprivacy$reptile$util$ParameterPasser).getName(), params);
            this.setParameters(t, params);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            System.out.println("Applying stylesheet: " + stylesheetURI);
            t.transform(xml_source, result);
            xml_source = new SAXSource(xmlReader, new InputSource(new StringReader(bos.toString())));
            dumputil.dump(sde, bos.toString(), step);
            if (ss.empty()) {
                return bos.toString();
            }
            ++step;
        }
        throw new Exception("NO CONTENT");
    }

    private void setParameters(Transformer t, ParameterPasser params) {
        Enumeration enumeration = params.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = (String)params.get(name);
            t.setParameter(name, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

