/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jasper.compiler.JavaCompiler;

public class JikesJavaCompiler
implements JavaCompiler {
    static final int OUTPUT_BUFFER_SIZE = 1024;
    static final int BUFFER_SIZE = 512;
    String encoding;
    String classpath;
    String compilerPath = "jikes";
    String outdir;
    OutputStream out;
    boolean classDebugInfo = false;

    public boolean compile(String source) {
        boolean isOkay;
        int exitValue = -1;
        String[] compilerCmd = this.classDebugInfo ? new String[]{this.compilerPath, "-g", "-classpath", this.classpath, "-d", this.outdir, "-nowarn", source} : new String[]{this.compilerPath, "-classpath", this.classpath, "-d", this.outdir, "-nowarn", source};
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(1024);
        try {
            Process p = Runtime.getRuntime().exec(compilerCmd);
            BufferedInputStream compilerErr = new BufferedInputStream(p.getErrorStream());
            StreamPumper errPumper = new StreamPumper(compilerErr, tmpErr);
            errPumper.start();
            p.waitFor();
            exitValue = p.exitValue();
            errPumper.join();
            compilerErr.close();
            p.destroy();
            tmpErr.close();
            tmpErr.writeTo(this.out);
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        boolean bl = isOkay = exitValue == 0;
        if (tmpErr.size() > 0) {
            isOkay = false;
        }
        return isOkay;
    }

    public void setClassDebugInfo(boolean classDebugInfo) {
        this.classDebugInfo = classDebugInfo;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setCompilerPath(String compilerPath) {
        this.compilerPath = compilerPath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMsgOutput(OutputStream out) {
        this.out = out;
    }

    public void setOutputDir(String outdir) {
        this.outdir = outdir;
    }

    class StreamPumper
    extends Thread {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private boolean stopSignal = false;
        private int SLEEP_TIME = 5;
        private OutputStream out;

        public StreamPumper(BufferedInputStream is, OutputStream out) {
            this.stream = is;
            this.out = out;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[512];
            if (!this.endOfStream) {
                int bytesRead = this.stream.read(buf, 0, 512);
                if (bytesRead > 0) {
                    this.out.write(buf, 0, bytesRead);
                } else if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    Thread.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {}
        }
    }
}

