/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class IncludeGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    Hashtable params;

    public IncludeGenerator(Mark start, Hashtable attrs, Hashtable param) throws JasperException {
        this.page = (String)attrs.get("page");
        if (this.page == null) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        String flush = (String)attrs.get("flush");
        if (flush == null) {
            throw new CompileException(start, Constants.getString("jsp.error.include.noflush"));
        }
        if (!flush.equals("true")) {
            throw new CompileException(start, Constants.getString("jsp.error.include.badflush"));
        }
        if (attrs.size() != 2) {
            throw new CompileException(start, Constants.getString("jsp.error.include.tag"));
        }
        this.params = param;
        this.isExpression = JspUtil.isExpression(this.page);
    }

    public void generate(ServletWriter writer, Class phase) {
        boolean initial = true;
        String sep = "?";
        writer.println("{");
        writer.pushIndent();
        writer.println("String _jspx_qStr = \"\";");
        if (this.params.size() > 0) {
            Enumeration en = this.params.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String[] value = (String[])this.params.get(key);
                if (initial) {
                    sep = "?";
                    initial = false;
                } else {
                    sep = "&";
                }
                if (value.length == 1 && JspUtil.isExpression(value[0])) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + " + JspUtil.getExpr(value[0]) + ";");
                    continue;
                }
                if (value.length == 1) {
                    writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[0] + "\";");
                    continue;
                }
                int i = 0;
                while (i < value.length) {
                    if (!JspUtil.isExpression(value[i])) {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" + \"" + value[i] + "\";");
                    } else {
                        writer.println("_jspx_qStr = _jspx_qStr + \"" + sep + key + "=\" +" + JspUtil.getExpr(value[i]) + ";");
                    }
                    if (sep.equals("?")) {
                        sep = "&";
                    }
                    ++i;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("pageContext.include(" + writer.quoteString(this.page) + " + _jspx_qStr);");
        } else {
            writer.println("pageContext.include(" + JspUtil.getExpr(this.page) + " + _jspx_qStr);");
        }
        writer.popIndent();
        writer.println("}");
    }
}

