/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.util.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openprivacy.sierra.util.sql.BaseStatement;
import org.openprivacy.sierra.util.sql.SelectType;
import talon.ComponentFactory;

public class Select
extends BaseStatement {
    private ResultSet resultSet = null;

    private String buildSQLStatement() {
        Vector vector = new Vector();
        vector = this.buildSQLStatementVector(this.getStrings(), vector, 1);
        vector = this.buildSQLStatementVector(this.getIntegers(), vector, 2);
        return this.buildSQLStatement(vector);
    }

    private String buildSQLStatement(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * FROM ");
        stringBuffer.append(this.getTable());
        stringBuffer.append(" WHERE ");
        int n = 0;
        while (n < vector.size()) {
            SelectType selectType = (SelectType)vector.elementAt(n);
            stringBuffer.append(selectType.getName());
            stringBuffer.append(" = ");
            if (selectType.getType() == 1) {
                stringBuffer.append("'");
            }
            stringBuffer.append(selectType.getValue().toString());
            if (selectType.getType() == 1) {
                stringBuffer.append("'");
            }
            if (n < vector.size() - 1) {
                stringBuffer.append(" AND  ");
            }
            ++n;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private Vector buildSQLStatementVector(Hashtable hashtable, Vector vector, int n) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            vector.addElement(new SelectType(n, string, v));
        }
        return vector;
    }

    public void commit() throws Exception {
        String string = this.buildSQLStatement();
        Connection connection = this.getDatabaseConnectionPool().getConnection();
        Statement statement = connection.createStatement();
        ComponentFactory.getLogger().debug(string);
        this.resultSet = statement.executeQuery(string);
        connection.commit();
        this.getDatabaseConnectionPool().releaseConnection(connection);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

